% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/datatools.R
\name{pca2euclid}
\alias{pca2euclid}
\title{Compute the Euclidean distance among principal components.}
\usage{
pca2euclid(.pcaobj, .num.comps = 2)
}
\arguments{
\item{.pcaobj}{An object returned by \code{prcomp}.}

\item{.num.comps}{On how many principal components compute the distance.}
}
\value{
Matrix of distances.
}
\description{
Compute the Euclidean distance among principal components.
}
\examples{
\dontrun{
mat.ov <- repOverlap(AS_DATA, .norm = T)
mat.gen.pca <- pca.segments(AS_DATA, T, .genes = HUMAN_TRBV)
mat.ov.pca <- prcomp(mat.ov, scale. = T)
mat.gen.pca.dist <- pca2euclid(mat.gen.pca)
mat.ov.pca.dist <- pca2euclid(mat.ov.pca)
permutDistTest(mat.gen.pca.dist, list(<list of groups here>))
permutDistTest(mat.ov.pca.dist, list(<list of groups here>))
}
}
\seealso{
\link{prcomp}, \link{pca.segments}, \link{repOverlap}, \link{permutDistTest}
}

