% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcga.R
\docType{data}
\name{tcga}
\alias{tcga}
\title{Biological data}
\source{
\itemize{
\item dataset: gene expression RNAseq - Batch effects normalized mRNA data
\item hub: \url{https://pancanatlas.xenahubs.net}
\item cohort: TCGA Pan-Cancer (PANCAN)
\item dataset ID: EB++AdjustPANCAN_IlluminaHiSeq_RNASeqV2.geneExp.xena
\item download: \url{https://tcga-pancan-atlas-hub.s3.us-east-1.amazonaws.com/download/EB\%2B\%2BAdjustPANCAN_IlluminaHiSeq_RNASeqV2.geneExp.xena.gz} (full metadata)
\item samples: 11060
\item version: 2016-12-29
\item type of data: gene expression RNAseq
\item unit: log2(norm_value+1)
\item raw data: \url{https://www.synapse.org/#!Synapse:syn4976369.3}
\item input data format: ROWs (identifiers) x COLUMNs (samples) (i.e. genomicMatrix)
}
}
\usage{
data(tcga)
}
\description{
A list of biological data: RNASeq data, phenotypic
metadata and cell abundance.
}
\details{
\itemize{
\item \code{genes}: RNASeq from The Cancer Genome Atlas (TCGA) database.
\item \code{phenotypes}: Metadata from the TCGA database containing
sample ID, sample type ID, sample type and primary disease.
\item \code{cells}: Abundance estimates of cell types
}
}
\note{
Subset of thirty samples of invasive breast carcinoma data from primary
tumor tissue. The cell type data are from a subset generated by the
Cibersort_ABS algorithm (\url{https://cibersort.stanford.edu/}).
For the complete dataset, please use:
\cr\cr
\code{path <- system.file("extdata", package = "tcgaViz")}
\cr
\code{load(file.path(path, "tcga.rda"))}
}
\examples{
data(tcga)
(df <- convert2biodata(
    algorithm = "Cibersort_ABS",
    disease = "breast invasive carcinoma",
    tissue = "Primary Tumor",
    gene_x = "ICOS"
))
(stats <- calculate_pvalue(df))
\donttest{
plot(df, stats = stats)
}
}
\keyword{datasets}
