% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_sim_voomlike.R
\name{compute_sim_voomlike}
\alias{compute_sim_voomlike}
\title{Computing simulations results}
\usage{
compute_sim_voomlike(counts, design, gs_keep, indiv, alternative = FALSE,
  fixed_eff = 0.5, fixed_eff_sd = 0, rand_eff_sd = 0.25,
  RE_indiv_sd = NULL, eps_sd = 0.05)
}
\description{
Computing simulations results
}
\examples{

\dontrun{
data_sims <- data_sim_voomlike(maxGSsize=300, minGSsize=30)
res <- compute_sim_voomlike(counts = data_sims$counts,
                           design = data_sims$design,
                           gs_keep = data_sims$gs_keep,
                           indiv = data_sims$indiv,
                           alternative=FALSE,
                           RE_indiv_sd=0.1)
res_all <- cbind(res$res_voom, res$res_perso, res$res_noweights)
colnames(res_all) <- paste0(rep(c("asym", "perm", "camera"), 3),
                           rep(c("_voom", "_perso", "_noweights"), each=3))
}

}
\keyword{internal}

