% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tclustIC.R
\name{tclustIC}
\alias{tclustIC}
\alias{print.tclustIC}
\title{Performs cluster analysis by calling \code{\link{tclust}} for different
 number of groups \code{k} and restriction factors \code{c}}
\usage{
tclustIC(
  x,
  kk = 1:5,
  cc = c(1, 2, 4, 8, 16, 32, 64, 128),
  alpha = 0.05,
  whichIC = c("ALL", "MIXMIX", "MIXCLA", "CLACLA"),
  parallel = FALSE,
  n.cores = -1,
  trace = FALSE,
  ...
)
}
\arguments{
\item{x}{A matrix or data frame of dimension n x p, containing the observations (row-wise).}

\item{kk}{an integer vector specifying the number of mixture components (clusters) 
for which the information criteria are be calculated. By default \code{kk=1:5}.}

\item{cc}{an  vector specifying the values of the restriction factor which have to 
be considered. By default \code{cc=c(1, 2, 4, 8, 16, 32, 64, 128)}.}

\item{alpha}{The proportion of observations to be trimmed.}

\item{whichIC}{A character value which specifies which information criteria must be computed
for each \code{k} (number of groups) and each value of the restriction factor 
\code{c}. Possible values for \code{whichIC} are:
\itemize{
 \item "MIXMIX": a mixture model is fitted and for computing the information criterion
    the mixture likelihood is used. This option corresponds to the use of the Bayesian
    Information criterion (BIC). In output just the matrix \code{MIXMIX} is given.
\item "MIXCLA": a mixture model is fitted but to compute the information criterion
    the classification likelihood is used. This option corresponds to the use of the
    Integrated Complete Likelihood (ICL). In the output just the matrix \code{MIXCLA} is given.
\item "CLACLA": everything is based on the classification likelihood. This information
    criterion will be called CLA. In the output just the matrix \code{CLACLA} is given.
\item "ALL": both classification and mixture likelihood are used. In this case all
    three information criteria CLA, ICL and BIC are computed. In the output all
    three matrices \code{MIXMIX}, \code{MIXCLA} and \code{CLACLA} are given.
}}

\item{parallel}{A logical value, specifying whether the calls to \code{\link{tclust}} should be done in parallel.}

\item{n.cores}{The number of cores to use when paralellizing, only taken into account if \code{parallel=TRUE}.}

\item{trace}{Whether to print intermediate results. Default is \code{trace=FALSE}.}

\item{\ldots}{Further arguments (as e.g. \code{restr}), passed to \code{\link{tclust}}}
}
\value{
The functions \code{print()} and \code{summary()} are used to obtain and print a
 summary of the results. The function returns an S3 object of type \code{tclustIC} containing the following components:
\itemize{
 \item call the matched call
 \item kk a vector containing the values of \code{k} (number of components) which have been considered.
     This vector is identical to the optional argument \code{kk} (default is \code{kk=1:5}.
 \item cc a vector containing the values of \code{c} (values of the restriction factor) which
     have been considered. This vector is identical to the optional argument \code{cc} (defalt is \code{cc=c(1, 2, 4, 8, 16, 32, 64, 128)}.
 \item alpha trimming level
 \item whichIC Information criteria used 
 \item CLACLA a matrix of size \code{length(kk)-times-length(cc)} containinig the value of
     the penalized classification likelihood. This output is present only if \code{whichIC="CLACLA"} or  \code{whichIC="ALL"}.
 \item IDXCLA a matrix of lists of size \code{length(kk)-times-length(cc)} containinig the assignment of each unit
     using the classification model. This output is present only if \code{whichIC="CLACLA"} or  \code{whichIC="ALL"}.
 \item MIXMIX a matrix of size \code{length(kk)-times-length(cc)} containinig the value of
     the penalized mixtrue likelihood. This output is present only if \code{whichIC="MIXMIX"} or  \code{whichIC="ALL"}.
 \item IDXMIX a matrix of lists of size \code{length(kk)-times-length(cc)} containinig the assignment of each unit
     using the classification model. This output is present only if \code{whichIC="MIXMIX"} or  \code{whichIC="ALL"}.
 \item MIXCLA a matrix of size \code{length(kk)-times-length(cc)} containinig the value of
     the ICL criterion. This output is present only if \code{whichIC="MIXCLA"} or  \code{whichIC="ALL"}.
 }
}
\description{
Computes the values of BIC (MIXMIX), ICL (MIXCLA) or CLA (CLACLA),
 for different values of \code{k} (number of groups) and different values of \code{c}
 (restriction factor), for a prespecified level of trimming (the last two letters in the name
 stand for 'Information Criterion').
}
\examples{

 #--- EXAMPLE 1 ------------------------------------------
 \donttest{
 data(geyser2)
 (out <- tclustIC(geyser2, whichIC="MIXMIX", alpha=0.1))
 summary(out)
 ## Find the smallest value inside the table and write the corresponding
 ## values of k (number of groups) and c (restriction factor)
 inds <- which(out$MIXMIX == min(out$MIXMIX), arr.ind=TRUE)
 vals <- out$MIXMIX[inds]
 cat("\nThe smallest value of the IC is ", vals, 
     " and takes place for k=", out$kk[inds[1]], " and c=",   
     out$cc[inds[2]], "\n")
 }

 #--- EXAMPLE 2 ------------------------------------------
 \donttest{
 data(flea)
 Y <- as.matrix(flea[, 1:(ncol(flea)-1)])    # select only the numeric variables
 rownames(Y) <- 1:nrow(Y)
 head(Y)

 (out <- tclustIC(Y, whichIC="CLACLA", alpha=0.1))
 summary(out)
 ## Find the smallest value inside the table and write the corresponding
 ## values of k (number of groups) and c (restriction factor)
 inds <- which(out$CLACLA == min(out$CLACLA), arr.ind=TRUE)
 vals <- out$CLACLA[inds]
 cat("\nThe Smallest value of the IC is ", vals, 
     " and takes place for k=", out$kk[inds[1]], " and c=",   
     out$cc[inds[2]], "\n")
 }

 #--- EXAMPLE 3 ------------------------------------------
 \donttest{
 data(swissbank)
 (out <- tclustIC(swissbank, whichIC="ALL"))
 
 plot(out)  ##  --> selecting k=3, c=128
 
 ##  the selected model
 plot(tclust(swissbank, k = 3, alpha = 0.1, restr.fact = 128))
 
 }

}
\references{
Cerioli, A., Garcia-Escudero, L.A., Mayo-Iscar, A. and Riani M. (2017).
     Finding the Number of Groups in Model-Based Clustering via Constrained Likelihoods,
     \emph{Journal of Computational and Graphical Statistics}, pp. 404-416,
     https://doi.org/10.1080/10618600.2017.1390469.
}
\seealso{
\code{\link{tclust}}
}
