% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcplVarMat.R
\name{tcplVarMat}
\alias{tcplVarMat}
\title{Create chemical by assay matrices}
\usage{
tcplVarMat(chid = NULL, aeid = NULL, add.vars = NULL, row.id = "code",
  flag = TRUE, cyto.pars = list(), include.na.chid = FALSE, odir = NULL,
  file.prefix = NULL)
}
\arguments{
\item{chid}{Integer, chemical ID values to subset on}

\item{aeid}{Integer, assay endpoint ID values to subset on}

\item{add.vars}{Character, mc4 or mc5 field(s) not included in the standard
list to add additional matrices}

\item{row.id}{Character, the chemical identifier to use in the output}

\item{flag}{Integer or Logical of length 1, passed to 
\code{\link{tcplSubsetChid}}}

\item{cyto.pars}{List, named list of arguments passed to 
\code{\link{tcplCytoPt}}}

\item{include.na.chid}{Logical of length 1, whether to include the chemicals
not listed in the tcpl databases (ie. controls)}

\item{odir}{Directory to write comma separated file(s)}

\item{file.prefix}{Character of length 1, prefix to the file name when odir
is not NULL}
}
\value{
A list of chemical by assay matrices where the rownames are given by
the 'row.id' paramter, and the colnames are given by assay endpoint name 
(aenm).
}
\description{
\code{tcplVarMat} creates chemical by assay matrices.
}
\details{
The \code{tcplVarMat} function is used to create chemical by assay matrices
for different paramters. The standard list of matrices returned includes:

\enumerate{
 \item "modl_ga" -- The logAC50 (in the gain direction) for the winning 
 model. 
 \item "hitc" -- The hit-call for the winning model.
 \item "m4id" -- The m4id, listing the concentration series selected by 
 \code{tcplSubsetChid}.
 \item "zscore" -- The z-score based on the output from \code{tcplCytoPt}. 
 The formula used for calculating the z-score is 
 \eqn{-(\mathit{modl\_ga} - \mathit{cyto\_pt})/\mathit{global\_mad}}
 \item "tested" -- 1 or 0, 1 indicating the chemical/assay pair
 was tested in either the single- or multiple-concentration format
 \item "tested_sc" -- 1 or 0, 1 indicating the chemical/assay pair
 was tested in the single-concentration format
 \item "tested_mc" -- 1 or 0, 1 indicating the chemical/assay pair
 was tested in the multiple-concentration format
 \item "ac50" -- a modified AC50 table (in non-log units) where 
 assay/chemical pairs that were not tested, or tested and had a hitcall of 0
 or -1 have the value 1e6. 
 \item "neglogac50" -- -log(AC50/1e6) where assay/chemical pairs that were 
 not tested, or tested and had a hitcall of 0 or -1 have the value 0. 
}

To add addtitional matrices, the 'add.vars' parameter can be used to specify
the fields from the mc4 or mc5 tables to create matrices for.

When more than one sample is included for a chemical/assay pair, 
\code{tcplVarMat} aggregates multiple samples to a chemical level call 
utilizing \code{\link{tcplSubsetChid}}. 

By setting \code{odir} the function will write out a csv with, naming the 
file with the convention: "var_Matrix_date.csv" where 'var' is the name 
of the matrix. A prefix can be added to the output files using the 
'file.prefix' paramter. 

When a concentration series has a sample id not listed in the \code{tcpl} 
database, and 'include.na.chid' is TRUE, the rowname for that series will 
be the concatenation of "SPID_" and the spid. Note, if the user gives a 
subset of chid values to the 'chid' parameter, 'include.na.chid' will be 
set to FALSE with a warning.

The tcplVarMat function calls both \code{tcplSubsetChid} and 
\code{tcplCytoPt} (which separately calls \code{tcplSubsetChid}). The input
for the \code{tcplVarMat} 'flag' parameter is passed to the 
\code{tcplSubsetChid} call used to parse down the data to create the 
matrices. The \code{tcplSubsetChid} called within \code{tcplCytoPt} (to 
parse down the cytotoxicity data used to define the "zscore" matrix) can 
be modified by passing a separate 'flag' element in the list defined by the 
'cyto.pars' parameter.
}
\examples{
## Store the current config settings, so they can be reloaded at the end 
## of the examples
conf_store <- tcplConfList()
tcplConfDefault()

## Demonstrate the returned values. Note with no "burst" assays defined in
## the example database, the user must provide which aeid values to use 
## in calculating the cytotoxicity distributions for the 'zscore' matrix.
tcplVarMat(chid = 1:5, cyto.pars = list(aeid = 1:2))

## Other changes can be made
tcplVarMat(chid = 1:5, row.id = "chnm", cyto.pars = list(aeid = 1:2))
tcplVarMat(chid = 1:5, add.vars = "max_med", cyto.pars = list(aeid = 1:2))

## Reset configuration
options(conf_store)

}
\seealso{
\code{\link{tcplSubsetChid}}
}

