% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcplMakeAeidMultiPlts.R
\name{tcplMakeAeidMultiPlts}
\alias{tcplMakeAeidMultiPlts}
\title{Create a .pdf with all dose-response plots for a given aeid, 6 per page}
\usage{
tcplMakeAeidMultiPlts(
  aeid,
  lvl = 4L,
  fname = NULL,
  odir = getwd(),
  clib = NULL,
  hitc.all = TRUE
)
}
\arguments{
\item{aeid}{Integer of length 1, the assay endpoint id}

\item{lvl}{Integer of length 1, the data level to use (4-7)}

\item{fname}{Character, the filename}

\item{odir}{The directory to save the .pdf file in}

\item{clib}{Character, the chemical library to subset on, see 
\code{\link{tcplLoadClib}} for more information.}

\item{hitc.all}{If FALSE, only plots with hitc==1 will be displayed}
}
\description{
\code{tcplMakeAeidMultiPlts} Create a .pdf with all dose-response plots for a given aeid
}
\details{
\code{tcplMakeAeidMultiPlts} provides a wrapper for \code{\link{tcplMultiplot}},
allowing the user to produce PDFs with the curve plots without having to 
separately load all of the data and establish the PDF device.

If 'fname' is \code{NULL}, a default name is given by concatenating together
assay information.
}
