% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcplDefine.R
\name{tcplDefine}
\alias{tcplDefine}
\title{Load data dictionary descriptions}
\usage{
tcplDefine(val = NULL)
}
\arguments{
\item{val}{The values to query on. Can be any combination of table names
(to return all of its field descriptions) and field names}
}
\value{
A data.table with the data dictionary information for the given
parameters.
}
\description{
\code{tcplDefine} queries the tcpl databases and returns field descriptions 
from the data dictionary.
}
\details{
Short descriptions of fields for different tables are stored in a data
dictionary. Query by table name to retrieve descriptions of each field in
the given table, and/or query by field name to retrieve descriptions on
every field with the given name, regardless of which table they belong to.
}
\examples{
## Store the current config settings, so they can be reloaded at the end 
## of the examples
conf_store <- tcplConfList()
tcplConf(drvr = "example")

## Passing no parameters returns all of the fields described in the data
## dictionary
tcplDefine()

## Specifying table names of 'chemical' and 'sample' yields all of the
## fields from the 'chemical' and 'sample' tables
tcplDefine(c("chemical", "sample"))

## Specifying a field of 'wllt' yields all of the fields from any table that
## contains 'wllt' as a field
tcplDefine("wllt")

## Specifying a combination of table and field names results in all of the
## fields which are contained in the given tables and all of the given fields
## found in any table
tcplDefine(c("chemical", "spid", "wllt"))

## Reset configuration
options(conf_store)

}
