% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concRespPlot.R
\name{concRespPlot}
\alias{concRespPlot}
\title{Concentration Response Plot}
\usage{
concRespPlot(row, ymin = -120, ymax = 120, draw.error.arrows = FALSE)
}
\arguments{
\item{row}{Named list containing:
\itemize{
  \item conc - conc string separated by |'s
  \item resp - response string separated by |'s
  \item method - scoring method determines plot bounds
  \item name - chemical name for plot title
  \item cutoff - noise cutoff
  \item bmr - baseline median response; level at which bmd is calculated
  \item er - fitted error term for plotting error bars
  \item a, tp, b, ga, p, la, q - other model parameters for fit curve
  \item fit_method - curve fit method
  \item bmd, bmdl, bmdu - bmd, bmd lower bound, and bmd upper bound
  \item ac50, acc - curve value at 50\% of top, curve value at cutoff
  \item top - curve top
  \item other identifiers
}
Other elements are ignored.}

\item{ymin}{Minimum value of respone for the plot}

\item{ymax}{Maximum value of respone for the plot}

\item{draw.error.arrows}{If TRUE, draw lines prepresenting the uncertainty in the response estimate,
instead of the actual response points}
}
\value{
No output.
}
\description{
Plots a concentration response curve for one sample/endpoint combination.
This is a generic function and it is expected that users will make their own versions
}
\details{
row is one row of data from concRespCore
}
