% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nestselect.R
\name{nestselect}
\alias{nestselect}
\title{Nest Select}
\usage{
nestselect(aics, mod1, mod2, dfdiff, pval = 0.05)
}
\arguments{
\item{aics}{Named vector of model aics (can include extra models).}

\item{mod1}{Name of model 1, the model with fewer degrees of freedom.}

\item{mod2}{Name of model 2, the model with more degrees of freedom.}

\item{dfdiff}{Absolute difference in number of degrees of freedom
(i.e. the difference in parameters).}

\item{pval}{P-value for nested model test.}
}
\value{
Named aic vector with losing model removed.
}
\description{
Chooses between nested models.
}
\examples{
aics = c(-5,-6,-3)
names(aics) = c("poly1", "poly2", "hill")
nestselect(aics, "poly1", "poly2", 1)

aics = c(-5,-7,-3)
names(aics) = c("poly1", "poly2", "hill")
nestselect(aics, "poly1", "poly2", 1)
}
