% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-vpd-param.R
\name{vpd-dials}
\alias{vpd-dials}
\alias{num_coef}
\alias{poly_type}
\alias{img_sigma}
\alias{num_levels}
\alias{weight_func_pl}
\alias{bandwidth}
\alias{weight_power}
\alias{num_bars}
\alias{num_bins}
\alias{tent_shift}
\title{Tune Vectorizations of Persistent Homology}
\usage{
num_coef(range = c(1L, unknown()), trans = NULL)

poly_type(values = c("R", "S", "T"), trans = NULL)

img_sigma(range = c(unknown(), unknown()), trans = transform_log10())

num_levels(range = c(1L, unknown()), trans = NULL)

weight_func_pl(
  values = c("triangle", "epanechnikov", "tricubic"),
  trans = NULL
)

bandwidth(range = c(unknown(), unknown()), trans = transform_log10())

weight_power(range = c(1, 2), trans = NULL)

num_bars(range = c(1L, unknown()), trans = NULL)

num_bins(range = c(2L, 20L), trans = NULL)

tent_shift(range = c(unknown(), unknown()), trans = transform_log10())
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::transform_log10()} or \code{scales::transform_reciprocal()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}

\item{values}{A character string of possible values.}
}
\value{
A \code{param} object or list of \code{param} objects.
}
\description{
These tuning functions govern the parameters of
vectorizations implemented in \strong{TDAvec}.
}
\details{
The parameter \code{num_coef} is passed to \code{m} in
\code{\link[TDAvec:computeComplexPolynomial]{TDAvec::computeComplexPolynomial()}}.

The parameter \code{poly_type} is passed to \code{polyType} in
\code{\link[TDAvec:computeComplexPolynomial]{TDAvec::computeComplexPolynomial()}}.

The parameter \code{img_sigma} is passed to \code{sigma} in
\code{\link[TDAvec:computePersistenceImage]{TDAvec::computePersistenceImage()}}.

The parameter \code{num_levels} is passed to \code{k} in
\code{\link[TDAvec:computePersistenceLandscape]{TDAvec::computePersistenceLandscape()}}.

The parameter \code{weight_func_pl} is passed to \code{kernel} in
\code{\link[TDAvec:computePersistenceLandscape]{TDAvec::computePersistenceLandscape()}}.

The parameter \code{bandwidth} is passed to \code{h} in
\code{\link[TDAvec:computePersistenceLandscape]{TDAvec::computePersistenceLandscape()}}.

The parameter \code{weight_power} is passed to \code{p} in
\code{\link[TDAvec:computePersistenceSilhouette]{TDAvec::computePersistenceSilhouette()}}.

The parameter \code{num_bars} is passed to \code{r} in
\code{\link[TDAvec:computeTropicalCoordinates]{TDAvec::computeTropicalCoordinates()}}.

The parameter \code{num_bins} is passed to \code{d} in
\code{\link[TDAvec:computeTemplateFunction]{TDAvec::computeTemplateFunction()}}.

The parameter \code{tent_shift} is passed to \code{epsilon} in
\code{\link[TDAvec:computeTemplateFunction]{TDAvec::computeTemplateFunction()}}.
}
\examples{
data.frame(dist = I(list(eurodist, UScitiesD * 1.6))) \%>\%
  transform(pd = I(lapply(dist, ripserr::vietoris_rips))) \%>\%
  subset(select = c(pd)) \%>\%
  print() -> pd_data

# `num_coef` for `step_vpn_complex_polynomial()`

(nc_man <- num_coef(range = c(1L, 3L)))
grid_regular(nc_man)

# `poly_type` for `step_vpn_complex_polynomial()`

(pt_man <- poly_type(values = c("R", "S")))
grid_regular(pt_man)

# `img_sigma` for `step_vpn_persistence_image()`

(is_man <- img_sigma(range = c(100, 400), trans = NULL))
grid_regular(is_man)

(is_dat <- img_sigma() \%>\% get_pers_max_frac(x = pd_data))
grid_regular(is_dat)

(is_hom <- img_sigma() \%>\% get_pers_max_frac(x = pd_data, hom_degrees = seq(2L)))
grid_regular(is_hom)

# `num_levels` for `step_vpn_persistence_landscape()`

(nl_man <- num_levels(range = c(1L, 6L)))
grid_regular(nl_man)

# `weight_func_pl` for `step_vpn_persistence_landscape()`

(wfp_man <- weight_func_pl(values = c("triangle", "tricubic")))
grid_regular(wfp_man)

# `bandwidth` for `step_vpn_persistence_landscape()`

(b_man <- bandwidth(range = c(500, 1500), trans = NULL))
grid_regular(b_man)

(b_dat <- bandwidth() \%>\% get_pers_max_frac(x = pd_data))
grid_regular(b_dat)

(b_hom <- bandwidth() \%>\% get_pers_max_frac(x = pd_data, hom_degrees = seq(2L)))
grid_regular(b_hom)

# `weight_power` for `step_vpn_persistence_silhouette()`

(wp_man <- weight_power(range = c(1, 3)))
grid_regular(wp_man)

# `num_bars` for `step_vpn_tropical_coordinates()`

(nb_man <- num_bars(range = c(1L, 3L)))
grid_regular(nb_man)

# `num_bins` for `step_vpn_tent_template_functions()`

(nb_man <- num_bins(range = c(5L, 10L)))
grid_regular(nb_man)

# `tent_shift` for `step_vpn_tent_template_functions()`

(ts_man <- tent_shift(range = c(100, 200), trans = NULL))
grid_regular(ts_man)

(ts_dat <- tent_shift() \%>\% get_pers_min_mult(x = pd_data))
grid_regular(ts_dat)

(ts_hom <- tent_shift() \%>\% get_pers_min_mult(x = pd_data, hom_degrees = seq(2L)))
grid_regular(ts_hom)

}
