% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency.R
\name{f.yearly}
\alias{f.yearly}
\title{Creates an Annual Frequency}
\usage{
f.yearly(year)
}
\arguments{
\item{year}{Year of the observation}
}
\value{
An object of class 'ldtf'. It is also a list with the following members:
\tabular{ll}{
\code{class} \tab Determines the class of this frequency.\cr
\code{year} \tab Determines the \code{year}.
}
}
\description{
Use it to create a frequency for time-series data that occurs annually.
}
\details{
In order to use \code{\link{as.frequency}} function for this type of frequency,
you need the following information:
\itemize{
\item \strong{Character Format} \code{"#"} (the number is the \code{year})
\item \strong{Class Id} \code{"y"}
}
}
\examples{

y0 <- f.yearly(2020) # this initializes a 'yearly' frequency

y0_value_str <-  as.character(y0) # this will be '2020'.
y0_class_str <- get.class.id(y0) # this will be 'y'.

y_new <- as.frequency("2021", "y") # this is a yearly frequency. It points to year 2021.

}
