% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_t_binary_outcome.R
\name{tm_t_binary_outcome}
\alias{tm_t_binary_outcome}
\title{teal Module: Binary Outcome Table}
\usage{
tm_t_binary_outcome(
  label,
  dataname,
  parentname = ifelse(test = inherits(arm_var, "data_extract_spec"), yes =
    teal.transform::datanames_input(arm_var), no = "ADSL"),
  arm_var,
  arm_ref_comp = NULL,
  paramcd,
  strata_var,
  aval_var = teal.transform::choices_selected(choices =
    teal.transform::variable_choices(dataname, c("AVALC", "SEX")), selected = "AVALC",
    fixed = FALSE),
  conf_level = teal.transform::choices_selected(c(0.95, 0.9, 0.8), 0.95, keep_order =
    TRUE),
  default_responses = c("CR", "PR", "Y", "Complete Response (CR)",
    "Partial Response (PR)", "M"),
  rsp_table = FALSE,
  control = list(global = list(method = ifelse(rsp_table, "clopper-pearson", "waldcc"),
    conf_level = 0.95), unstrat = list(method_ci = ifelse(rsp_table, "wald", "waldcc"),
    method_test = "schouten", odds = TRUE), strat = list(method_ci = "cmh", method_test =
    "cmh")),
  add_total = FALSE,
  total_label = default_total_label(),
  na_level = tern::default_na_str(),
  denom = c("N_col", "n", "N_row"),
  pre_output = NULL,
  post_output = NULL,
  basic_table_args = teal.widgets::basic_table_args(),
  transformators = list(),
  decorators = list()
)
}
\arguments{
\item{label}{(\code{character})\cr menu item label of the module in the teal app.}

\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{arm_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for variable names that can be used as \code{arm_var}.
It defines the grouping variable in the results table.}

\item{arm_ref_comp}{(\code{list}) optional,\cr if specified it must be a named list with each element corresponding to
an arm variable in \code{ADSL} and the element must be another list (possibly
with delayed \code{\link[teal.transform:variable_choices]{teal.transform::variable_choices()}} or delayed \code{\link[teal.transform:value_choices]{teal.transform::value_choices()}}
with the elements named \code{ref} and \code{comp} that the defined the default
reference and comparison arms when the arm variable is changed.}

\item{paramcd}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the parameter code variable from \code{dataname}.}

\item{strata_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr names of
the variables for stratified analysis.}

\item{aval_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and pre-selected option for the analysis variable.}

\item{conf_level}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and pre-selected option for the confidence level, each within range of (0, 1).}

\item{default_responses}{(\code{list} or \code{character})\cr defines
the default codes for the response variable in the module per value of \code{paramcd}.
A passed vector is transmitted for all \code{paramcd} values. A passed \code{list} must be named
and contain arrays, each name corresponding to a single value of \code{paramcd}. Each array
may contain default response values or named arrays \code{rsp} of default selected response
values and \code{levels} of default level choices.}

\item{rsp_table}{(\code{logical})\cr whether the initial set-up of the module should match \code{RSPT01}. Defaults to \code{FALSE}.}

\item{control}{(named \code{list})\cr named list containing 3 named lists as follows:
\itemize{
\item \code{global}: a list of settings for overall analysis with 2 named elements \code{method} and \code{conf_level}.
\item \code{unstrat}: a list of settings for unstratified analysis with 3 named elements \code{method_ci} and \code{method_test}, and
\code{odds}. See \code{\link[tern:prop_diff]{tern::estimate_proportion_diff()}}, \code{\link[tern:prop_diff_test]{tern::test_proportion_diff()}}, and
\code{\link[tern:odds_ratio]{tern::estimate_odds_ratio()}}, respectively, for options and details on how these settings are implemented in the
analysis.
\item \code{strat}: a list of settings for stratified analysis with elements \code{method_ci} and \code{method_test}. See
\code{\link[tern:prop_diff]{tern::estimate_proportion_diff()}} and \code{\link[tern:prop_diff_test]{tern::test_proportion_diff()}}, respectively, for options and details on
how these settings are implemented in the analysis.
}}

\item{add_total}{(\code{logical})\cr whether to include column with total number of patients.}

\item{total_label}{(\code{string})\cr string to display as total column/row label if column/row is
enabled (see \code{add_total}). Defaults to \code{"All Patients"}. To set a new default \code{total_label} to
apply in all modules, run \code{set_default_total_label("new_default")}.}

\item{na_level}{(\code{string})\cr used to replace all \code{NA} or empty values
in character or factor variables in the data. Defaults to \code{"<Missing>"}. To set a
default \code{na_level} to apply in all modules, run \code{set_default_na_str("new_default")}.}

\item{denom}{(\code{string})\cr choice of denominator for proportion. Options are:
\itemize{
\item \code{N_col}: total number of patients in this column across rows.
\item \code{n}: number of patients with any occurrences.
\item \code{N_row}: total number of patients in this row across columns.
}}

\item{pre_output}{(\code{shiny.tag}) optional,\cr with text placed before the output to put the output into context.
For example a title.}

\item{post_output}{(\code{shiny.tag}) optional,\cr with text placed after the output to put the output into context.
For example the \code{\link[shiny:helpText]{shiny::helpText()}} elements are useful.}

\item{basic_table_args}{(\code{basic_table_args}) optional\cr object created by \code{\link[teal.widgets:basic_table_args]{teal.widgets::basic_table_args()}}
with settings for the module table. The argument is merged with option \code{teal.basic_table_args} and with default
module arguments (hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-basic-table-arguments", package = "teal.widgets")}.}

\item{transformators}{(\code{list} of \code{teal_transform_module}) that will be applied to transform module's data input.
To learn more check \code{vignette("transform-input-data", package = "teal")}.}

\item{decorators}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
(named \code{list} of lists of \code{teal_transform_module}) optional,
decorator for tables or plots included in the module output reported.
The decorators are applied to the respective output objects.

See section "Decorating Module" below for more details.}
}
\value{
a \code{teal_module} object.
}
\description{
This module produces a binary outcome response summary table, with the option to match the template for
response table \code{RSPT01} available in the TLG Catalog \href{https://insightsengineering.github.io/tlg-catalog/stable/tables/efficacy/rspt01.html}{here}.
}
\details{
\itemize{
\item The display order of response categories inherits the factor level order of the source data. Use
\code{\link[base:factor]{base::factor()}} and its \code{levels} argument to manipulate the source data in order to include/exclude
or re-categorize response categories and arrange the display order. If response categories are \code{"Missing"},
\code{"Not Evaluable (NE)"}, or \code{"Missing or unevaluable"}, 95\% confidence interval will not be calculated.
\item Reference arms are automatically combined if multiple arms selected as reference group.
}
}
\section{Decorating Module}{


This module generates the following objects, which can be modified in place using decorators:
\itemize{
\item \code{table} (\code{TableTree} - output of \code{rtables::build_table()})
}

A Decorator is applied to the specific output using a named list of \code{teal_transform_module} objects.
The name of this list corresponds to the name of the output to which the decorator is applied.
See code snippet below:

\if{html}{\out{<div class="sourceCode">}}\preformatted{tm_t_binary_outcome(
   ..., # arguments for module
   decorators = list(
     table = teal_transform_module(...) # applied only to `table` output
   )
)
}\if{html}{\out{</div>}}

For additional details and examples of decorators, refer to the vignette
\code{vignette("decorate-module-output", package = "teal.modules.clinical")}.

To learn more please refer to the vignette
\code{vignette("transform-module-output", package = "teal")} or the \code{\link[teal:teal_transform_module]{teal::teal_transform_module()}} documentation.
}

\examples{
library(dplyr)

data <- teal_data()
data <- within(data, {
  ADSL <- tmc_ex_adsl
  ADRS <- tmc_ex_adrs \%>\%
    mutate(
      AVALC = d_onco_rsp_label(AVALC) \%>\%
        with_label("Character Result/Finding")
    ) \%>\%
    filter(PARAMCD != "OVRINV" | AVISIT == "FOLLOW UP")
})
join_keys(data) <- default_cdisc_join_keys[names(data)]

ADSL <- data[["ADSL"]]
ADRS <- data[["ADRS"]]

arm_ref_comp <- list(
  ARMCD = list(ref = "ARM B", comp = c("ARM A", "ARM C")),
  ARM = list(ref = "B: Placebo", comp = c("A: Drug X", "C: Combination"))
)
app <- init(
  data = data,
  modules = modules(
    tm_t_binary_outcome(
      label = "Responders",
      dataname = "ADRS",
      paramcd = choices_selected(
        choices = value_choices(ADRS, "PARAMCD", "PARAM"),
        selected = "BESRSPI"
      ),
      arm_var = choices_selected(
        choices = variable_choices(ADRS, c("ARM", "ARMCD", "ACTARMCD")),
        selected = "ARM"
      ),
      arm_ref_comp = arm_ref_comp,
      strata_var = choices_selected(
        choices = variable_choices(ADRS, c("SEX", "BMRKR2", "RACE")),
        selected = "RACE"
      ),
      default_responses = list(
        BESRSPI = list(
          rsp = c("Complete Response (CR)", "Partial Response (PR)"),
          levels = c(
            "Complete Response (CR)", "Partial Response (PR)",
            "Stable Disease (SD)", "Progressive Disease (PD)"
          )
        ),
        INVET = list(
          rsp = c("Stable Disease (SD)", "Not Evaluable (NE)"),
          levels = c(
            "Complete Response (CR)", "Not Evaluable (NE)", "Partial Response (PR)",
            "Progressive Disease (PD)", "Stable Disease (SD)"
          )
        ),
        OVRINV = list(
          rsp = c("Progressive Disease (PD)", "Stable Disease (SD)"),
          levels = c("Progressive Disease (PD)", "Stable Disease (SD)", "Not Evaluable (NE)")
        )
      ),
      denom = "N_col"
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
\seealso{
The \href{https://insightsengineering.github.io/tlg-catalog/stable/}{TLG Catalog} where additional example
apps implementing this module can be found.
}
\section{Examples in Shinylive}{
\describe{
  \item{example-1}{
    \href{https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpXSYsO-VNVaNFEEr8UKRQ+kZc1AD6waHWQSFhhjoA7rSkABa0EOyxULg6IEo6OgCCACIAygAy4TqkMARRcAAeUVD8otTFZeVYlXUNTa3t-IyiOgCkAHyTPSUwgqHk7PMlZQBqpdUAwjoAvDr8USTEUeOoUdRQ9HDU7KVbuzYzcxDrH6npGVc3d6tgHYZFhQdSqHRYMTCUgAegAYtl+NkAOYKMABD4vWZrYy0ajkRjsAAKpSwpQAsjtyjoAISHNEAeQ2WAAkgA5DZonQAH02LMqLNsB3pYDhDOq1QZAHUdA4iWiAgBfAIAKyI2SiAGs4KxRLlEjZkvw4MYoNCogQkaImmqNdrdcBoPA9Xk5ABdVwQCo1Op5YDANHe6pot0er19AZGxL+wMRkNhpQsGDnE0WogwVB1OiiUird5lLCU6mHbO5xgmg46QOFnQAITRBWIGcrBABpPJZQbVbA7Z0OwVclwPV7JdoOfY5eMlbRtcQOiJ1wIcHoRC7Tczh1bgbn5UYgmROgAGl20Ts5zt0-RsiFLIF0QEAmhM8lsuk8yU8pW8kP83whCIJkOP9hDEd91gaKJSCiK9oDYE4libOAwI+a5bmoacwEhURUBIY1xgbNYP0SJ1dBFCp+gI-MPlQEFGn4FsMnVJdRCiUQ7jgMF+GQz4CEYmQxErTRuEEOALT45iHgjAo0RJMkixPMBZIpBUf0+dY2JETiMNrJxKn6IkWTRQidEHYykyiITGAYpixFY9jOO4j5eJswCdEs2gbhEMSXMk-pGzbQsFPbKkgp2WxgvKAdVLUnQNI48h6LIwKwGM0yqPWczJzTZtDky1N12ij4c2YUILJYaz+JYuKHOMkpnMqwSWA8+gvPqiTyMqfy0UqJxjzwbta3JLAAGksAAJgUskdhce9Cs+aqEowqaZtSuaPxNM18RTbCSDY1zS0c9YdL0yoDMrA7avWC4WwBC8MxEcgITEHCIDYnR2B2LBFH6mSWA0bgnp217dGJL6VMukoRG0ahXK3dKYu7O6fDgR6sJet6PrBn7FL+jz0LR3aQaJLG1pi7rQha3RyjHOAoAxypym+6TFMYIhkXLURRC0KmabponGaM+HPgxGK0oR9kNicIVR3HCGdGuzcAUqCmRB0am2L596GaZ7s2SIUgdCcITqEETyQbZJxvrFhGdChu5YcOtTT3TZHUeewn3s+nW0T1g2jeEs33ot72ccYf78fd4H3uJpm5ZKGTWfZsQue0NXeYxokBex5XA-V2n6azuWRbU621KZVkOXOsdczlhWdC3Fm2Y5lOeY1jOs+ZnPKbTtuQe18GhZQuBoYdhOm+T7me-z-mQ671W8819h++x33DeN03u-YYOFUu4v1lL9ZjQgdMMLZNNuhS9KRYfJRaCndhsgJUENG0awbCKfNRCyCBWFKdB2CfAAEkELQAoQC2KMG0P4JQiolBgEVG6IAA}{Open in Shinylive}
    \if{html}{\out{<iframe class="iframe_shinylive" src="https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpXSYsO-VNVaNFEEr8UKRQ+kZc1AD6waHWQSFhhjoA7rSkABa0EOyxULg6IEo6OgCCACIAygAy4TqkMARRcAAeUVD8otTFZeVYlXUNTa3t-IyiOgCkAHyTPSUwgqHk7PMlZQBqpdUAwjoAvDr8USTEUeOoUdRQ9HDU7KVbuzYzcxDrH6npGVc3d6tgHYZFhQdSqHRYMTCUgAegAYtl+NkAOYKMABD4vWZrYy0ajkRjsAAKpSwpQAsjtyjoAISHNEAeQ2WAAkgA5DZonQAH02LMqLNsB3pYDhDOq1QZAHUdA4iWiAgBfAIAKyI2SiAGs4KxRLlEjZkvw4MYoNCogQkaImmqNdrdcBoPA9Xk5ABdVwQCo1Op5YDANHe6pot0er19AZGxL+wMRkNhpQsGDnE0WogwVB1OiiUird5lLCU6mHbO5xgmg46QOFnQAITRBWIGcrBABpPJZQbVbA7Z0OwVclwPV7JdoOfY5eMlbRtcQOiJ1wIcHoRC7Tczh1bgbn5UYgmROgAGl20Ts5zt0-RsiFLIF0QEAmhM8lsuk8yU8pW8kP83whCIJkOP9hDEd91gaKJSCiK9oDYE4libOAwI+a5bmoacwEhURUBIY1xgbNYP0SJ1dBFCp+gI-MPlQEFGn4FsMnVJdRCiUQ7jgMF+GQz4CEYmQxErTRuEEOALT45iHgjAo0RJMkixPMBZIpBUf0+dY2JETiMNrJxKn6IkWTRQidEHYykyiITGAYpixFY9jOO4j5eJswCdEs2gbhEMSXMk-pGzbQsFPbKkgp2WxgvKAdVLUnQNI48h6LIwKwGM0yqPWczJzTZtDky1N12ij4c2YUILJYaz+JYuKHOMkpnMqwSWA8+gvPqiTyMqfy0UqJxjzwbta3JLAAGksAAJgUskdhce9Cs+aqEowqaZtSuaPxNM18RTbCSDY1zS0c9YdL0yoDMrA7avWC4WwBC8MxEcgITEHCIDYnR2B2LBFH6mSWA0bgnp217dGJL6VMukoRG0ahXK3dKYu7O6fDgR6sJet6PrBn7FL+jz0LR3aQaJLG1pi7rQha3RyjHOAoAxypym+6TFMYIhkXLURRC0KmabponGaM+HPgxGK0oR9kNicIVR3HCGdGuzcAUqCmRB0am2L596GaZ7s2SIUgdCcITqEETyQbZJxvrFhGdChu5YcOtTT3TZHUeewn3s+nW0T1g2jeEs33ot72ccYf78fd4H3uJpm5ZKGTWfZsQue0NXeYxokBex5XA-V2n6azuWRbU621KZVkOXOsdczlhWdC3Fm2Y5lOeY1jOs+ZnPKbTtuQe18GhZQuBoYdhOm+T7me-z-mQ671W8819h++x33DeN03u-YYOFUu4v1lL9ZjQgdMMLZNNuhS9KRYfJRaCndhsgJUENG0awbCKfNRCyCBWFKdB2CfAAEkELQAoQC2KMG0P4JQiolBgEVG6IAA" style="height: 800px; width: 100vw; max-width: 1400px; border: 1px solid rgba(0,0,0,0.175); border-radius: .375rem; position: absolute; left: 50\%; margin-top: 30px; transform: translateX(-50\%); z-index: 1"></iframe>}}
    \if{html}{\out{<a style='height: 800px; display: block;'></a>}}
  }
}
}

