% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{add_expr}
\alias{add_expr}
\title{Expression List}
\usage{
add_expr(expr_ls, new_expr)
}
\arguments{
\item{expr_ls}{(\code{list} of \code{call})\cr the list to which a new expression
should be added.}

\item{new_expr}{(\code{call})\cr the new expression to add.}
}
\value{
a \code{list} of \code{call}.
}
\description{
Add a new expression to a list (of expressions).
}
\details{
Offers a stricter control to add new expressions to an existing
list. The list of expressions can be later used to generate a pipeline,
for instance with \code{pipe_expr}.
}
\examples{
library(rtables)

lyt <- list()
lyt <- add_expr(lyt, substitute(basic_table()))
lyt <- add_expr(
  lyt, substitute(split_cols_by(var = arm), env = list(armcd = "ARMCD"))
)
lyt <- add_expr(
  lyt,
  substitute(
    test_proportion_diff(
      vars = "rsp", method = "cmh", variables = list(strata = "strat")
    )
  )
)
lyt <- add_expr(lyt, quote(build_table(df = dta)))
pipe_expr(lyt)
}
