% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_filter_manager.R
\name{module_filter_manager}
\alias{module_filter_manager}
\alias{filter_manager_ui}
\alias{filter_manager_srv}
\title{Manage multiple \code{FilteredData} objects}
\usage{
filter_manager_ui(id)

filter_manager_srv(id, filtered_data_list, filter)
}
\arguments{
\item{id}{(\code{character(1)})
\code{shiny} module id.}

\item{filtered_data_list}{(named \code{list})
A list, possibly nested, of \code{FilteredData} objects.
Each \code{FilteredData} will be served to one module in the \code{teal} application.
The structure of the list must reflect the nesting of modules in tabs
and the names of the list must match the labels of their respective modules.}

\item{filter}{(\code{teal_slices})
Specifies the initial filter using \code{\link[=teal_slices]{teal_slices()}}.}
}
\value{
A list of \code{reactive}s, each holding a \code{teal_slices}, as returned by \code{filter_manager_module_srv}.
}
\description{
Oversee filter states across the entire application.
}
\details{
This module observes changes in the filters of each \code{FilteredData} object
and keeps track of all filters used. A mapping of filters to modules
is kept in the \code{mapping_matrix} object (which is actually a \code{data.frame})
that tracks which filters (rows) are active in which modules (columns).
}
\keyword{internal}
