% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teal_slices-store.R
\name{slices_store}
\alias{slices_store}
\alias{slices_restore}
\title{Store and restore \code{teal_slices} object}
\usage{
slices_store(tss, file)

slices_restore(file)
}
\arguments{
\item{tss}{(\code{teal_slices}) object to be stored.}

\item{file}{(\code{character(1)}) file path where \code{teal_slices} object will be
saved and restored. The file extension should be \code{".json"}.}
}
\value{
\code{slices_store} returns \code{NULL}, invisibly.

\code{slices_restore} returns a \code{teal_slices} object restored from the file.
}
\description{
Functions that write a \code{teal_slices} object to a file in the \code{JSON} format,
and also restore the object from disk.
}
\details{
Date and date time objects are stored in the following formats:
\itemize{
\item \code{Date} class is converted to the \code{"ISO8601"} standard (\code{YYYY-MM-DD}).
\item \code{POSIX*t} classes are converted to character by using
\code{format.POSIX*t(usetz = TRUE, tz = "UTC")} (\verb{YYYY-MM-DD HH:MM:SS UTC}, where
\code{UTC} is the \verb{Coordinated Universal Time} timezone short-code).
}

This format is assumed during \code{slices_restore}. All \code{POSIX*t} objects in
\code{selected} or \code{choices} fields of \code{teal_slice} objects are always printed in
\code{UTC} timezone as well.
}
\seealso{
\code{\link[=teal_slices]{teal_slices()}}
}
\keyword{internal}
