% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkmate.R
\name{check_reactive}
\alias{check_reactive}
\alias{test_reactive}
\alias{assert_reactive}
\title{Check that argument is reactive.}
\usage{
check_reactive(x, null.ok = FALSE)

test_reactive(x, null.ok = FALSE)

assert_reactive(
  x,
  null.ok = FALSE,
  .var.name = checkmate::vname(x),
  add = NULL
)
}
\arguments{
\item{x}{[\code{any}]\cr
Object to check.}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link[checkmate]{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link[checkmate]{AssertCollection}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertClass}/\code{assert_class} return 
 \code{x} invisibly, whereas
 \code{checkClass}/\code{check_class} and 
 \code{testClass}/\code{test_class} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertClass}/\code{assert_class}
 throws an error message, 
 \code{testClass}/\code{test_class}
 returns \code{FALSE},
 and \code{checkClass}/\code{check_class} 
 return a string with the error message.
 The function \code{expect_class} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check that argument is reactive.
}
\keyword{internal}
