% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolation.R
\name{stress2grid}
\alias{stress2grid}
\alias{stress2grid_stats}
\title{Spatial Interpolation of SHmax}
\source{
\url{https://github.com/MorZieg/Stress2Grid}
}
\usage{
stress2grid(
  x,
  stat = c("mean", "median"),
  grid = NULL,
  lon_range = NULL,
  lat_range = NULL,
  gridsize = 2,
  min_data = 3L,
  threshold = 25,
  arte_thres = 200,
  method_weighting = FALSE,
  quality_weighting = TRUE,
  dist_weight = c("inverse", "linear", "none"),
  idp = 1,
  qp = 1,
  mp = 1,
  dist_threshold = 0.1,
  R_range = seq(50, 1000, 50),
  ...
)

stress2grid_stats(
  x,
  grid = NULL,
  lon_range = NULL,
  lat_range = NULL,
  gridsize = 2,
  min_data = 4L,
  threshold = 25,
  arte_thres = 200,
  method_weighting = FALSE,
  quality_weighting = TRUE,
  dist_weight = c("inverse", "linear", "none"),
  idp = 1,
  qp = 1,
  mp = 1,
  dist_threshold = 0.1,
  R_range = seq(50, 1000, 50),
  kappa = NULL,
  ...
)
}
\arguments{
\item{x}{\code{sf} object containing
\describe{
\item{azi}{SHmax in degree}
\item{unc}{(optional) Uncertainties of SHmax in degree}
\item{type}{(optional) Methods used for the determination of the direction
of SHmax}
}}

\item{stat}{whether the direction of interpolated SHmax is based on the
circular mean and standard deviation (\code{"mean"}, the default) or the
circular median and interquartile range (\code{"median"})}

\item{grid}{(optional) Point object of class \code{sf}.}

\item{lon_range, lat_range}{(optional) numeric vector specifying the minimum
and maximum longitudes and latitudes (ignored if \code{grid} is specified).}

\item{gridsize}{numeric. Target spacing of the regular grid in decimal
degree. Default is \code{2.5}. (is ignored if \code{grid} is specified)}

\item{min_data}{integer. Minimum number of data per bin. Default is \code{3} for
\code{\link[=stress2grid]{stress2grid()}}and \code{4} for \code{\link[=stress2grid_stats]{stress2grid_stats()}}.}

\item{threshold}{numeric. Threshold for deviation of direction. Default is
\code{25}}

\item{arte_thres}{numeric. Maximum distance (in km) of the grid point to the
next data point. Default is \code{200}}

\item{method_weighting}{logical. If a method weighting should be applied:
Default is \code{FALSE}. If \code{FALSE}, overwrites \code{mp}.}

\item{quality_weighting}{logical. If a quality weighting should be applied:
Default is \code{TRUE}. If \code{FALSE}, overwrites \code{qp}.}

\item{dist_weight}{Distance weighting method which should be used. One of
\code{"none"}, \code{"linear"}, or \code{"inverse"} (the default).}

\item{idp, qp, mp}{numeric. The weighting power of inverse distance, quality
and method. Default is \code{1}. The higher the value, the more weight it will
put. When set to \code{0}, no weighting is applied. \code{idp} is only effective if
inverse distance weighting (\code{dist_weight="inverse"}) is applied.}

\item{dist_threshold}{numeric. Distance weight to prevent overweight of data
nearby (0 to 1). Default is \code{0.1}}

\item{R_range}{numeric value or vector specifying the kernel half-width(s),
i.e. the search radius (in km). Default is \code{seq(50, 1000, 50)}}

\item{...}{(optional) arguments to \code{\link[=dist_greatcircle]{dist_greatcircle()}}}

\item{kappa}{numeric. von Mises distribution concentration parameter used
for the circular mode. Will be estimated using \code{\link[=est.kappa]{est.kappa()}} if not provided.}
}
\value{
\code{sf} object containing
\describe{
\item{lon,lat}{longitude and latitude in degrees}
\item{azi}{Mean SHmax in degree}
\item{sd}{Standard deviation of SHmax in degrees}
\item{R}{Search radius in km}
\item{mdr}{Mean distance of datapoints per search radius}
\item{N}{Number of data points in search radius}
}
When \code{\link[=stress2grid_stats]{stress2grid_stats()}}, \code{azi} and \code{sd} are replaced by the output of
\code{\link[=circular_summary]{circular_summary()}}.
}
\description{
Stress field interpolation and wavelength analysis using a kernel (weighted)
mean/median and standard deviation/IQR of stress data
}
\details{
\code{\link[=stress2grid]{stress2grid()}} is a modified version of the MATLAB script
"stress2grid" by Ziegler and Heidbach (2019).
\code{\link[=stress2grid_stats]{stress2grid_stats()}} is based on \code{\link[=stress2grid]{stress2grid()}} but yields more circular
summary statistics (see \code{\link[=circular_summary]{circular_summary()}}).
}
\examples{
data("san_andreas")
stress2grid(san_andreas, stat = "median")
\dontrun{
stress2grid_stats(san_andreas)
}
}
\references{
Ziegler, M. and Heidbach, O. (2019).
Matlab Script Stress2Grid v1.1. GFZ Data Services. \doi{10.5880/wsm.2019.002}
}
\seealso{
\code{\link[=dist_greatcircle]{dist_greatcircle()}}, \code{\link[=PoR_stress2grid]{PoR_stress2grid()}}, \code{\link[=compact_grid]{compact_grid()}},
\code{\link[=circular_mean]{circular_mean()}}, \code{\link[=circular_median]{circular_median()}}, \code{\link[=circular_sd]{circular_sd()}}, \code{\link[=circular_summary]{circular_summary()}}
}
