% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bot.R
\name{sendSticker}
\alias{sendSticker}
\title{Send a sticker}
\usage{
sendSticker(chat_id, sticker, disable_notification = FALSE,
  reply_to_message_id = NULL, reply_markup = NULL)
}
\arguments{
\item{chat_id}{Unique identifier for the target chat or username of
the target channel.}

\item{sticker}{Sticker to send. Pass a file_id as String to send a file that exists on
the Telegram servers (recommended), pass an HTTP URL as a String for Telegram to
get a \code{.webp} file from the Internet, or upload a local one by passing a file path.}

\item{disable_notification}{(Optional). Sends the message silently. Users will
receive a notification with no sound.}

\item{reply_to_message_id}{(Optional). If the message is a reply, ID of the
original message.}

\item{reply_markup}{(Optional). A Reply Markup parameter object, it can be either:
\itemize{
 \item{\code{\link{ReplyKeyboardMarkup}}}
 \item{\code{\link{InlineKeyboardMarkup}}}
 \item{\code{\link{ReplyKeyboardRemove}}}
 \item{\code{\link{ForceReply}}}}}
}
\description{
Use this method to send \code{.webp} stickers.
}
\details{
You can also use it's snake_case equivalent \code{send_sticker}.
}
\examples{
\dontrun{
bot <- Bot(token = bot_token("RTelegramBot"))
chat_id <- user_id("Me")
sticker_url <- "https://www.gstatic.com/webp/gallery/1.webp"

bot$sendSticker(chat_id = chat_id,
                sticker = sticker_url)
}
}
