% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcata.R
\encoding{UTF-8}
\name{similarity.tcata.repeatability}
\alias{similarity.tcata.repeatability}
\title{Quantify TCATA assessor repeatability}
\usage{
similarity.tcata.repeatability(X)
}
\arguments{
\item{X}{list of matrices, where each matrix is a TCATA data (given as an indicator matrix) for assessor of interest for one rep}
}
\value{
repeatability.index average city block distance between matrices from replicated evaluations
}
\description{
Quantify TCATA assessor repeatability using city block distance
}
\details{
Similarity between repeated evaluations given by a TCATA assessor is quantified. The repeatability index can take on values between \code{0} and \code{1}, which indicate complete dissimilarity (non-repeatability) and complete similarity (repeatability), respectively.
}
\examples{
  # Toy data from one TCATA assessor on a product over three sessions: rep1, rep2, rep3
  rep1 <- rbind(rep(0, 7),
                rep(0, 7),
                c(0, 0, 0, 1, 1, 1, 1),
                c(0, 0, 0, 1, 1, 1, 1),
                c(0, 0, 0, 1, 1, 1, 0))
  rep2 <- rbind(c(0, 0, 0, 1, 1, 1, 0),
                rep(0, 7),
                c(0, 1, 1, 1, 1, 1, 0),
                rep(1, 7),
                c(0, 0, 0, 1, 1, 1, 1))
  rep3 <- rbind(rep(0, 7),
                rep(0, 7),
                rep(1, 7),
                rep(1, 7),
                rep(1, 7))
  rep.data <- list(rep1, rep2, rep3)

  # Quantify similarity of assessor a1 to the other assessors
  similarity.tcata.repeatability(rep.data)
}
\references{
Castura, J. C., Antúnez, L., Giménez, A., Ares, G. (2016). Temporal check-all-that-apply (TCATA): A novel temporal sensory method for characterizing products. \emph{Food Quality and Preference}, 47, 79-90. \url{http://dx.doi.org/10.1016/j.foodqual.2015.06.017}
}

