% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tds.R
\encoding{UTF-8}
\name{std.time}
\alias{std.time}
\title{Time standardize results}
\usage{
std.time(X, trim.left = TRUE, trim.right = TRUE, scale = TRUE,
  missing = 0)
}
\arguments{
\item{X}{vector (or data frame) of indicator data.}

\item{trim.left}{Trim on the left? Default is \code{TRUE}.}

\item{trim.right}{Trim on the right? Default is \code{TRUE}.}

\item{scale}{Set to a [0, 1] scale? Default is \code{TRUE}.}

\item{missing}{indicator for missing data; default is \code{0}.}
}
\value{
out vector (or data frame) of trimmed and/or standardized indicator (\code{0}/\code{1}) data
}
\description{
Set results for a temporal evaluation to a timescale by trimming off time prior to the first onset and following the last offset time, and express the remaining times in terms of percentiles [0, 100].
}
\examples{
# vector - toy data example
x <- rep(c(rep(0,18), rep(1,18)), 2)
names(x) <- 1:72
x           # raw time
std.time(x) # standardized time

# data frame - toy data example
y <- data.frame(rbind(c(c(rep(0,18),
                           rep(1,18)),
                           rep(0, 4)),
                           c(rep(c(rep(0,9),
                           rep(1,9)), 2),
                           1, rep(0, 3)),
                           rep(0, 40)))
colnames(y) <- 1:40
y           # raw time
std.time(y) # standardized time

# time standardization using 'bars' data set
# only sample 1 will be done (for illustrative purposes)
eval1 <- unique(bars[bars$sample == 1, (1:3)])
bar1.std <- data.frame(unique(bars[bars$sample == 1, (1:4)]), matrix(0, ncol = 101))

for (e in 1:nrow(eval1)){
  bar1.std[bar1.std$assessor == eval1$assessor[e] &
             bar1.std$session == eval1$session[e] &
             bar1.std$sample == eval1$sample[e],
             -c(1:4)] <- std.time(bars[bars$assessor == eval1$assessor[e] &
                                         bars$session == eval1$session[e] &
                                         bars$sample == eval1$sample[e],
                                           -c(1:4)])
}
colnames(bar1.std)[5:ncol(bar1.std)] <- 0:100
head(bar1.std)
}
\references{
Lenfant, F., Loret, C., Pineau, N., Hartmann, C., & Martin, N. (2009). Perception of oral food breakdown. The concept of sensory trajectory. \emph{Appetite}, 52, 659-667.
}

