% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual_reg.R
\name{dual_reg}
\alias{dual_reg}
\title{Dual Regression}
\usage{
dual_reg(
  BOLD,
  GICA,
  scale = c("global", "local", "none"),
  scale_sm_xifti = NULL,
  scale_sm_FWHM = 2,
  detrend_DCT = 0,
  center_Bcols = FALSE,
  normA = FALSE
)
}
\arguments{
\item{BOLD}{Subject-level fMRI data matrix (\eqn{V \times T}). Rows will be
centered.}

\item{GICA}{Group-level independent components (\eqn{V \times Q})}

\item{scale}{\code{"global"} (default), \code{"local"}, or \code{"none"}.
Global scaling will divide the entire data matrix by the mean image standard
deviation (\code{mean(sqrt(rowVars(BOLD)))}). Local scaling will divide each
data location's time series by its estimated standard deviation.}

\item{scale_sm_xifti, scale_sm_FWHM}{Only applies if \code{scale=="local"} and
\code{BOLD} represents CIFTI-format data. To smooth the standard deviation
estimates used for local scaling, provide a \code{"xifti"} object with data
locations in alignment with \code{BOLD}, as well as the smoothing FWHM
(default: \code{2}). If no \code{"xifti"} object is provided (default), do
not smooth.}

\item{detrend_DCT}{Detrend the data? This is an integer number of DCT bases
to use for detrending. If \code{0} (default), do not detrend.}

\item{center_Bcols}{Center BOLD across columns (each image)? This
is equivalent to performing global signal regression. Default:
\code{FALSE}.}

\item{normA}{Scale each IC timeseries (column of \eqn{A}) in the dual
regression estimates? Default: \code{FALSE} (not recommended). Note that the
product \eqn{A \times S} remains the same with either option.}
}
\value{
A list containing
the subject-level independent components \strong{S} (\eqn{V \times Q}),
and subject-level mixing matrix \strong{A} (\eqn{TxQ}).
}
\description{
Dual Regression
}
\examples{
nT <- 30
nV <- 400
nQ <- 7
mU <- matrix(rnorm(nV*nQ), nrow=nV)
mS <- mU \%*\% diag(seq(nQ, 1)) \%*\% matrix(rnorm(nQ*nT), nrow=nQ)
BOLD <- mS + rnorm(nV*nT, sd=.05)
GICA <- mU
dual_reg(BOLD=BOLD, GICA=mU, scale="local")

}
