% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensorBF.R
\name{getDefaultOpts}
\alias{getDefaultOpts}
\title{A function for generating a default set of parameters for Bayesian Tensor Factorization methods}
\usage{
getDefaultOpts(method = "CP")
}
\arguments{
\item{method}{the factorization method for which options are required.
Currently only "CP" (default) is supported.}
}
\value{
A list with the following model options:
\item{ARDX}{TRUE: use elementwise ARD prior for X, resulting in sparse X's.
FALSE: use guassian prior for a dense X (default).}
\item{ARDW}{TRUE: use elementwise ARD prior for W, resulting in sparse W's (default).
FALSE: use guassian prior for a dense W.}
\item{ARDU}{TRUE: use elementwise ARD prior for U, resulting in sparse U's.
FALSE: use guassian prior for a dense U (default).}
\item{iter.burnin}{The number of burn-in samples (default 5000).}
\item{iter.sampling}{The number of saved posterior samples (default 50).}
\item{iter.thinning}{The thinning factor to use in saving posterior samples (default 10).}
\item{prior.alpha_0t}{The shape parameter for residual noise (tau's) prior (default 1).}
\item{prior.beta_0t}{The rate parameter for residual noise (tau's) prior (default 1).}
\item{prior.alpha_0}{The shape parameter for the ARD precisions (default 1e-3).}
\item{prior.beta_0}{The rate parameter for the ARD precisions (default 1e-3).}
\item{prior.betaW1}{Bernoulli prior for component activiations, prior.betaW1 < prior.betaW2: sparsity inducing (default: 1).}
\item{prior.betaW2}{Bernoulli prior for component activation, (default: 1).}
\item{init.tau}{The initial value for noise precision (default 1e3).}
\item{verbose}{The verbosity level. 0=no printing, 1=moderate printing,
 2=maximal printing (default 1).}
\item{checkConvergence}{Check for the convergence of the data reconstruction,
 based on the Geweke diagnostic (default TRUE).}
}
\description{
\code{getDefaultOpts} returns the default choices for model parameters.
}
\details{
This function returns options for defining the model's high-level structure
(sparsity priors), the hyperparameters, and the uninformative
priors. We recommend keeping these as provided.
}
\examples{
#To run the algorithm with other values:
opts <- getDefaultOpts()
opts$ARDW <- FALSE #Switch off Feature-level Sparsity on W's
 \dontrun{res <- tensorBF(Y=Y,opts=opts)}
}

