% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.r, R/dtensor-math.r,
%   R/sptensor-math.r
\docType{methods}
\name{ttm}
\alias{ttm}
\alias{ttm,dtensor,Matrix,numeric-method}
\alias{ttm,dtensor,Matrix,numeric,numeric-method}
\alias{ttm,dtensor,matrix,numeric-method}
\alias{ttm,dtensor,matrix,numeric,numeric-method}
\alias{ttm,sptensor,Matrix,numeric-method}
\alias{ttm,sptensor,Matrix,numeric,numeric-method}
\alias{ttm,sptensor,matrix,numeric-method}
\alias{ttm,sptensor,matrix,numeric,numeric-method}
\title{Tensor times matrix}
\usage{
ttm(x, u, mode)

\S4method{ttm}{dtensor,Matrix,numeric}(x, u, mode)

\S4method{ttm}{dtensor,matrix,numeric}(x, u, mode)

\S4method{ttm}{sptensor,Matrix,numeric}(x, u, mode)

\S4method{ttm}{sptensor,matrix,numeric}(x, u, mode)
}
\arguments{
\item{x}{tensor}

\item{u}{matrix}

\item{mode}{mode along tensor to perform multiplication}
}
\description{
Calculates the n-mode product of a tensor and a matrix. Given a tensor X with
dimensions \eqn{I_1, I_2, ..., I_n, I_n+1, ... I_N} and a matrix U with
dimensions \eqn{J, I_n}, the resulting tensor after multiplication will have
dimension \eqn{I_1, I_2, ..., J, I_n+1, ... I_N}.
}
\references{
\cite{T. G. Kolda and B. W. Bader, Tensor Decompositions and
Applications, SIAM Review 51(3):455-500, September 2009}
}
