% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_equi_mcmc.R
\name{get_equi_bayes}
\alias{get_equi_bayes}
\title{Get the Bayes rule under multiway Stein's loss.}
\usage{
get_equi_bayes(psi_inv, sigma, burnin = NULL)
}
\arguments{
\item{psi_inv}{A list of arrays where \code{psi_inv[[i]][[, , j]]} is the
\eqn{j}th update of the \code{i}th component. These components are the
inverses of the lower-triangular Cholesky square roots of the component
covariance matrices. You can just use the \code{Phi_inv} output from
\code{equi_mcmc}.}

\item{sigma}{A vector of posteior draws of the total variation parameter.
This is just \code{sigma} from the output of \code{equi_mcmc}.}

\item{burnin}{A numeric between 0 and 1. What proportion of the posterior
samples do you want to discard as burnin? The default is 0.25.}
}
\value{
\code{Sig_hat} A list of the Bayes rules of the component covariance
  matrices under multiway Stein's loss.

  \code{B} A list of the lower-triangular Cholesky square roots of the Bayes
  rules of the component covariance matrices under multiway Stein's loss. We
  have that \code{Sig_hat[[i]]} is equal to \code{B[[i]] \%*\% t(B[[i]])}.

  \code{b} A numeric. This is the bayes rule of the total variation
  parameter. This is the 'standard deviation' version. That is, the \code{b ^
  2} would be used to calculate the overall covariance matrix.
}
\description{
Given the output of \code{equi_mcmc}, this function will calculate the Bayes
rule under multiway Stein's loss.
}
\details{
Multiway Stein's loss is a generalization of Stein's loss to more than two
dimensions. The Bayes rule under this loss is simply represented in terms of
the posterior moments of the component precision matrices. These moments can
be approximated by using the output of \code{equi_mcmc}. When using the
invariant prior that is used in \code{equi_mcmc}, the resulting Bayes rule is
the uniformly minimum risk equivariant estimator.

More details on multiway Stein's loss and the Bayes rules under it can be
found in
\href{http://www.sciencedirect.com/science/article/pii/S0047259X15000330}{
Gerard and Hoff (2015)}.
}
\examples{
#Generate data whose true covariance is just the identity.
p <- c(4,4,4)
X <- array(stats::rnorm(prod(p)),dim = p)
#Then run the Gibbs sampler.
mcmc_out <- equi_mcmc(X)
bayes_rules <- get_equi_bayes(mcmc_out$Phi_inv, mcmc_out$sigma)
bayes_rules$Sig_hat[[1]]
}
\author{
David Gerard.
}
\references{
Gerard, D., & Hoff, P. (2015).
  \href{http://www.sciencedirect.com/science/article/pii/S0047259X15000330}{Equivariant
  minimax dominators of the MLE in the array normal model}. \emph{Journal of
  Multivariate Analysis}, 137, 32-49.
}
\seealso{
\code{\link{equi_mcmc}}.
}
\keyword{equivariance}
\keyword{posterior}

