% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meandifference.R
\name{meandifference}
\alias{meandifference}
\title{Compute Mean and Differences of Scores for Each Condition}
\usage{
meandifference(resultsecdf, expdf, nbwindows, showtime = FALSE,
verbose = TRUE)
}
\arguments{
\item{resultsecdf}{A data frame containing ECDF results for each transcript
and condition (see genesECDF).}

\item{expdf}{A data frame containing experiment data that should have
columns named 'condition', 'replicate', 'strand', and 'path'.}

\item{nbwindows}{An integer representing the number of windows (or segments)
in each transcript.}

\item{showtime}{A logical value indicating if the duration of the function
processing should be indicated before ending. Defaults to
\code{FALSE}.}

\item{verbose}{A logical flag indicating whether to print progress messages.
Defaults to \code{TRUE}.}
}
\value{
A data frame that contains, for each condition:
\itemize{
  \item Mean values for the "value" and "Fx" columns (e.g.,
   \code{mean_value_ctrl}, \code{mean_Fx_ctrl}).
  \item Differences between the \code{Fx} column and coordinate ratios
   (e.g., \code{diff_Fx_ctrl}).
}
If only one condition is provided, the differences on mean columns are not
performed.
}
\description{
This function calculates the mean values, mean Fx (ECDF) and ECDF differences
(Fx) for expression data, across different experimental conditions. If only
one condition is provided, skips computation of mean differences.
}
\examples{
exppath <-  system.file("extdata", "exptab.csv", package="tepr")
transpath <- system.file("extdata", "cugusi_6.tsv", package="tepr")
expthres <- 0.1

## Calculating necessary results
expdf <- read.csv(exppath)
transdf <- read.delim(transpath, header = FALSE)
avfilt <- averageandfilterexprs(expdf, transdf, expthres,
        showtime = FALSE, verbose = FALSE)
countna <- countna(avfilt, expdf, nbcpu = 1, verbose = FALSE)
ecdf <- genesECDF(avfilt, expdf, verbose = FALSE)
resecdf <- ecdf[[1]]
nbwindows <- ecdf[[2]]

## Testing meandifference
meandifftest <- meandifference(resecdf, expdf, nbwindows,
    verbose = FALSE)

}
