% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.stergm.R
\name{control.stergm}
\alias{control.stergm}
\title{Auxiliary for Controlling Separable Temporal ERGM Fitting}
\usage{
control.stergm(
  init.form = NULL,
  init.diss = NULL,
  init.method = NULL,
  force.main = FALSE,
  MCMC.prop.form = ~discord + sparse,
  MCMC.prop.diss = ~discord + sparse,
  MCMC.prop.weights.form = "default",
  MCMC.prop.args.form = NULL,
  MCMC.prop.weights.diss = "default",
  MCMC.prop.args.diss = NULL,
  MCMC.maxedges = Inf,
  MCMC.maxchanges = 1e+06,
  MCMC.packagenames = c(),
  CMLE.MCMC.burnin = 1024 * 16,
  CMLE.MCMC.interval = 1024,
  CMLE.ergm = NULL,
  CMLE.form.ergm = control.ergm(init = init.form, MCMC.burnin = CMLE.MCMC.burnin,
    MCMC.interval = CMLE.MCMC.interval, MCMC.prop = MCMC.prop.form, MCMC.prop.weights =
    MCMC.prop.weights.form, MCMC.prop.args = MCMC.prop.args.form, MCMC.maxedges =
    MCMC.maxedges, MCMC.packagenames = MCMC.packagenames, parallel = parallel,
    parallel.type = parallel.type, parallel.version.check = parallel.version.check,
    force.main = force.main),
  CMLE.diss.ergm = control.ergm(init = init.diss, MCMC.burnin = CMLE.MCMC.burnin,
    MCMC.interval = CMLE.MCMC.interval, MCMC.prop = MCMC.prop.diss, MCMC.prop.weights =
    MCMC.prop.weights.diss, MCMC.prop.args = MCMC.prop.args.diss, MCMC.maxedges =
    MCMC.maxedges, MCMC.packagenames = MCMC.packagenames, parallel = parallel,
    parallel.type = parallel.type, parallel.version.check = parallel.version.check,
    force.main = force.main),
  CMLE.NA.impute = c(),
  CMLE.term.check.override = FALSE,
  EGMME.main.method = c("Gradient-Descent"),
  EGMME.initialfit.control = control.ergm(),
  EGMME.MCMC.burnin.min = 1000,
  EGMME.MCMC.burnin.max = 1e+05,
  EGMME.MCMC.burnin.pval = 0.5,
  EGMME.MCMC.burnin.add = 1,
  MCMC.burnin = NULL,
  MCMC.burnin.mul = NULL,
  SAN.maxit = 4,
  SAN.nsteps.times = 8,
  SAN = control.san(term.options = term.options, SAN.maxit = SAN.maxit, SAN.prop =
    MCMC.prop.form, SAN.prop.weights = MCMC.prop.weights.form, SAN.prop.args =
    MCMC.prop.args.form, SAN.nsteps = round(sqrt(EGMME.MCMC.burnin.min *
    EGMME.MCMC.burnin.max)) * SAN.nsteps.times, SAN.packagenames = MCMC.packagenames,
    parallel = parallel, parallel.type = parallel.type, parallel.version.check =
    parallel.version.check),
  SA.restarts = 10,
  SA.burnin = 1000,
  SA.plot.progress = FALSE,
  SA.max.plot.points = 400,
  SA.plot.stats = FALSE,
  SA.init.gain = 0.1,
  SA.gain.decay = 0.5,
  SA.runlength = 25,
  SA.interval.mul = 2,
  SA.init.interval = 500,
  SA.min.interval = 20,
  SA.max.interval = 500,
  SA.phase1.minruns = 4,
  SA.phase1.tries = 20,
  SA.phase1.jitter = 0.1,
  SA.phase1.max.q = 0.1,
  SA.phase1.backoff.rat = 1.05,
  SA.phase2.levels.max = 40,
  SA.phase2.levels.min = 4,
  SA.phase2.max.mc.se = 0.001,
  SA.phase2.repeats = 400,
  SA.stepdown.maxn = 200,
  SA.stepdown.p = 0.05,
  SA.stop.p = 0.1,
  SA.stepdown.ct = 5,
  SA.phase2.backoff.rat = 1.1,
  SA.keep.oh = 0.5,
  SA.keep.min.runs = 8,
  SA.keep.min = 0,
  SA.phase2.jitter.mul = 0.2,
  SA.phase2.maxreljump = 4,
  SA.guard.mul = 4,
  SA.par.eff.pow = 1,
  SA.robust = FALSE,
  SA.oh.memory = 1e+05,
  SA.refine = c("mean", "linear", "none"),
  SA.se = TRUE,
  SA.phase3.samplesize.runs = 10,
  SA.restart.on.err = TRUE,
  term.options = NULL,
  seed = NULL,
  parallel = 0,
  parallel.type = NULL,
  parallel.version.check = TRUE,
  ...
)
}
\arguments{
\item{init.form, init.diss}{numeric or \code{NA} vector equal in
length to the number of parameters in the formation/dissolution
model or \code{NULL} (the default); the initial values for the
estimation and coefficient offset terms. If \code{NULL} is
passed, all of the initial values are computed using the method
specified by \code{\link[=control.ergm]{control$init.method}}.
If a numeric vector is given, the elements of the vector are
interpreted as follows: \itemize{ \item Elements corresponding to
terms enclosed in \code{offset()} are used as the fixed offset
coefficients. These should match the offset values given in
\code{offset.coef.form} and \code{offset.coef.diss}.

\item Elements that do not correspond to offset terms and are not
\code{NA} are used as starting values in the estimation.

\item Initial values for the elements that are \code{NA} are fit
using the method specified by
\code{\link[=control.ergm]{control$init.method}}.

} Passing coefficients from a previous run can be used to
"resume" an uncoverged \code{\link{stergm}} run.}

\item{init.method}{Estimation method used to acquire initial values
for estimation. If \code{NULL} (the default), the initial values
are computed using the edges dissolution approximation (Carnegie
et al.) when appropriate; note that this relies on \code{\link{.extract.fd.formulae}}
to identify the formation and dissolution parts of the formula; the user should
be aware of its behavior and limitations.
If \code{init.method} is set to "zeros", the initial values are set to zeros.}

\item{force.main}{Logical: If TRUE, then force MCMC-based
estimation method, even if the exact MLE can be computed via
maximum pseudolikelihood estimation.}

\item{MCMC.prop.form}{Hints and/or constraints for selecting and initializing the proposal.}

\item{MCMC.prop.weights.form}{Specifies the proposal weighting to use.}

\item{MCMC.prop.args.form}{A direct way of specifying arguments to the proposal.}

\item{MCMC.prop.weights.diss, MCMC.prop.args.diss, MCMC.prop.diss}{Ignored.}

\item{MCMC.maxedges}{Maximum number of edges for which to
allocate space.}

\item{MCMC.maxchanges}{Maximum number of changes in dynamic
network simulation for which to allocate space.}

\item{MCMC.packagenames}{Names of packages in which to look for
change statistic functions in addition to those
autodetected. This argument should not be needed outside of very
strange setups.}

\item{CMLE.MCMC.burnin}{Burnin used in CMLE fitting.}

\item{CMLE.MCMC.interval}{Number of Metropolis-Hastings steps
between successive draws when running MCMC MLE.}

\item{CMLE.ergm}{A convenience argument for specifying both
\code{CMLE.form.ergm} and \code{CMLE.diss.ergm} at once.
See \code{\link{control.ergm}}.}

\item{CMLE.form.ergm}{Control parameters used to fit the CMLE.  See
\code{\link{control.ergm}}.}

\item{CMLE.diss.ergm}{Ignored, with the exception of initial parameter values.}

\item{CMLE.NA.impute}{In STERGM CMLE, missing dyads in
transitioned-to networks are accommodated using methods of
Handcock and Gile (2009), but a similar approach to
transitioned-from networks requires much more complex methods
that are not, currently, implemented.  \code{CMLE.NA.impute}
controls how missing dyads in transitioned-from networks are be
imputed. See argument \code{imputers} of
\code{\link{impute.network.list}} for details.

By default, no imputation is performed, and the fitting stops
with an error if any transitioned-from networks have missing
dyads.}

\item{CMLE.term.check.override}{The method
\code{\link{stergm}{stergm}} uses at this time to fit a series of
more than two networks requires certain assumptions to be made
about the ERGM terms being used, which are tested before a fit is
attempted. This test sometimes fails despite the model being
amenable to fitting, so setting this option to \code{TRUE}
overrides the tests.}

\item{EGMME.main.method}{Estimation method used to find the
Equilibrium Generalized Method of Moments estimator.  Currently
only "Gradient-Descent" is implemented.}

\item{EGMME.initialfit.control}{Control object for the ergm fit
in tergm.EGMME.initialfit}

\item{EGMME.MCMC.burnin.min, EGMME.MCMC.burnin.max, }{Number of
Metropolis-Hastings steps
per time step used in EGMME fitting. By default, this is
determined adaptively by keeping track of increments in the
Hamming distance between the transitioned-from network and the
network being sampled. Once \code{EGMME.MCMC.burnin.min} steps have elapsed,
the increments are tested against 0, and when their average
number becomes statistically indistinguishable from 0 (with the
p-value being greater than \code{EGMME.MCMC.burnin.pval}), or
\code{EGMME.MCMC.burnin.max} steps are proposed, whichever comes
first, the simulation is stopped after an additional
\code{EGMME.MCMC.burnin.add} times the number of elapsed steps
had been taken. (Stopping immediately would bias the sampling.)

To use a fixed number of steps, set
\code{EGMME.MCMC.burnin.min} and \code{EGMME.MCMC.burnin.max} to
the same value.}

\item{EGMME.MCMC.burnin.pval, EGMME.MCMC.burnin.add}{Number of
Metropolis-Hastings steps
per time step used in EGMME fitting. By default, this is
determined adaptively by keeping track of increments in the
Hamming distance between the transitioned-from network and the
network being sampled. Once \code{EGMME.MCMC.burnin.min} steps have elapsed,
the increments are tested against 0, and when their average
number becomes statistically indistinguishable from 0 (with the
p-value being greater than \code{EGMME.MCMC.burnin.pval}), or
\code{EGMME.MCMC.burnin.max} steps are proposed, whichever comes
first, the simulation is stopped after an additional
\code{EGMME.MCMC.burnin.add} times the number of elapsed steps
had been taken. (Stopping immediately would bias the sampling.)

To use a fixed number of steps, set
\code{EGMME.MCMC.burnin.min} and \code{EGMME.MCMC.burnin.max} to
the same value.}

\item{MCMC.burnin, MCMC.burnin.mul}{No longer used. See
\code{EGMME.MCMC.burnin.min}, \code{EGMME.MCMC.burnin.max},
\code{EGMME.MCMC.burnin.pval}, \code{EGMME.MCMC.burnin.pval},
\code{EGMME.MCMC.burnin.add} and \code{CMLE.MCMC.burnin} and
\code{CMLE.MCMC.interval}.}

\item{SAN.maxit}{When \code{target.stats} argument is passed to
\code{\link[=ergm]{ergm()}}, the maximum number of attempts to use \code{\link{san}}
to obtain a network with statistics close to those specified.}

\item{SAN.nsteps.times}{Multiplier for \code{SAN.nsteps} relative to
\code{MCMC.burnin}. This lets one control the amount of SAN burn-in
(arguably, the most important of SAN parameters) without overriding the
other SAN defaults.}

\item{SAN}{SAN control parameters.  See
\code{\link{control.san}}}

\item{SA.restarts}{Maximum number of times to restart a failed
optimization process.}

\item{SA.burnin}{Number of time steps to advance the starting
network before beginning the optimization.}

\item{SA.plot.progress, SA.plot.stats}{Logical: Plot information
about the fit as it proceeds. If \code{SA.plot.progress==TRUE},
plot the trajectories of the parameters and target statistics as
the optimization progresses. If \code{SA.plot.stats==TRUE}, plot
a heatmap representing correlations of target statistics and a
heatmap representing the estimated gradient.

Do NOT use these with non-interactive plotting devices like
\code{\link{pdf}}. (In fact, it will refuse to do that with a
warning.)}

\item{SA.max.plot.points}{If \code{SA.plot.progress==TRUE}, the
maximum number of time points to be plotted. Defaults to 400. If
more iterations elapse, they will be thinned to at most 400
before plotting.}

\item{SA.init.gain}{Initial gain, the multiplier for the parameter
update size.  If the process initially goes crazy beyond
recovery, lower this value.}

\item{SA.gain.decay}{Gain decay factor.}

\item{SA.runlength}{Number of parameter trials and updates per C
run.}

\item{SA.interval.mul}{The number of time steps between updates of
the parameters is set to be this times the mean duration of
extant ties.}

\item{SA.init.interval}{Initial number of time steps between
updates of the parameters.}

\item{SA.min.interval, SA.max.interval}{Upper and lower bounds on
the number of time steps between updates of the parameters.}

\item{SA.phase1.minruns}{Number of runs during Phase 1 for
estimating the gradient, before every gradient update.}

\item{SA.phase1.tries}{Number of runs trying to find a reasonable
parameter and network configuration.}

\item{SA.phase1.jitter}{Initial jitter standard deviation of each
parameter.}

\item{SA.phase1.max.q}{Q-value (false discovery rate) that a
gradient estimate must obtain before it is accepted (since sign
is what is important).}

\item{SA.phase1.backoff.rat, SA.phase2.backoff.rat}{If the run
produces this relative increase in the approximate objective
function, it will be backed off.}

\item{SA.phase2.levels.min, SA.phase2.levels.max}{Range of gain
levels (subphases) to go through.}

\item{SA.phase2.max.mc.se}{Approximate precision of the estimates
that must be attained before stopping.}

\item{SA.phase2.repeats, SA.stepdown.maxn, }{A gain level may be
repeated multiple times (up to \code{SA.phase2.repeats}) if the
optimizer detects that the objective function is improving or the
estimating equations are not centered around 0, so slowing down
the parameters at that point is counterproductive. To detect this
it looks at the the window controlled by \code{SA.keep.oh},
thinning objective function values to get
\code{SA.stepdown.maxn}, and 1) fitting a GLS model for a linear
trend, with AR(2) autocorrelation and 2) conductiong an
approximate Hotelling's T^2 test for equality of estimating
equation values to 0. If there is no significance for either at
\code{SA.stepdown.p} \code{SA.stepdown.ct} runs in a row, the
gain level (subphase) is allowed to end. Otherwise, the process
continues at the same gain level.}

\item{SA.stepdown.p, SA.stepdown.ct}{A gain level may be repeated
multiple times (up to \code{SA.phase2.repeats}) if the optimizer
detects that the objective function is improving or the
estimating equations are not centered around 0, so slowing down
the parameters at that point is counterproductive.  To detect
this it looks at the the window controlled by \code{SA.keep.oh},
thinning objective function values to get
\code{SA.stepdown.maxn}, and 1) fitting a GLS model for a linear
trend, with AR(2) autocorrelation and 2) conductiong an
approximate Hotelling's T^2 test for equality of estimating
equation values to 0. If there is no significance for either at
\code{SA.stepdown.p} \code{SA.stepdown.ct} runs in a row, the
gain level (subphase) is allowed to end. Otherwise, the process
continues at the same gain level.}

\item{SA.stop.p}{At the end of each gain level after the minimum,
if the precision is sufficiently high, the relationship between
the parameters and the targets is tested for evidence of local
nonlinearity. This is the p-value used.

If that test fails to reject, a Phase 3 run is made with the new
parameter values, and the estimating equations are tested for
difference from 0. If this test fails to reject, the optimization
is finished.

If either of these tests rejects, at \code{SA.stop.p},
optimization is continued for another gain level.}

\item{SA.keep.oh, SA.keep.min, SA.keep.min.runs}{Parameters
controlling how much of optimization history to keep for gradient
and covariance estimation.

A history record will be kept if it's at least one of the
following: \itemize{ \item Among the last \code{SA.keep.oh} (a
fraction) of all runs.  \item Among the last \code{SA.keep.min} (a
count) records.  \item From the last \code{SA.keep.min.runs} (a
count) optimization runs.  }}

\item{SA.phase2.jitter.mul}{Jitter standard deviation of each
parameter is this value times its standard deviation without
jitter.}

\item{SA.phase2.maxreljump}{To keep the optimization from
"running away" due to, say, a poor gradient estimate building on
itself, if a magnitude of change (Mahalanobis distance) in
parameters over the course of a run divided by average magnitude
of change for recent runs exceeds this, the change is truncated
to this amount times the average for recent runs.}

\item{SA.guard.mul}{The multiplier for the range of parameter and
statistics values to compute the guard width.}

\item{SA.par.eff.pow}{Because some parameters have much, much
greater effects than others, it improves numerical conditioning
and makes estimation more stable to rescale the \eqn{k}th
estimating function by \eqn{s_k = (\sum_{i=1}^{q}
  G_{i,k}^2/V_{i,i})^{-p/2}}, where \eqn{G_{i,k}} is the estimated
gradient of the \eqn{i}th target statistics with respect to
\eqn{k}th parameter. This parameter sets the value of \eqn{p}:
\code{0} for no rescaling, \code{1} (default) for scaling by
root-mean-square normalized gradient, and greater values for
greater penalty.}

\item{SA.robust}{Whether to use robust linear regression (for
gradients) and covariance estimation.}

\item{SA.oh.memory}{Absolute maximum number of data points per
thread to store in the full optimization history.}

\item{SA.refine}{Method, if any, used to refine the point estimate
at the end: "linear" for linear interpolation, "mean" for
average, and "none" to use the last value.}

\item{SA.se}{Logical: If TRUE (the default), get an MCMC sample of
statistics at the final estimate and compute the covariance
matrix (and hence standard errors) of the parameters. This sample
is stored and can also be used by
\code{\link[=mcmc.diagnostics]{mcmc.diagnostics()}} to assess convergence.}

\item{SA.phase3.samplesize.runs}{This many optimization runs will
be used to determine whether the optimization has converged and
to estimate the standard errors.}

\item{SA.restart.on.err}{Logical: if \code{TRUE} (the default) an
error somewhere in the optimization process will cause it to
restart with a smaller gain value. Otherwise, the process will
stop. This is mainly used for debugging}

\item{term.options}{A list of additional arguments to be passed to term initializers. It can also be set globally via \code{option(ergm.term=list(...))}.}

\item{seed}{Seed value (integer) for the random number generator.
See \code{\link[base]{set.seed}}}

\item{parallel}{Number of threads in which to run the
sampling. Defaults to 0 (no parallelism). See the entry on
\link[=ergm-parallel]{parallel processing} for details and
troubleshooting.}

\item{parallel.type}{API to use for parallel processing. Supported
values are \code{"MPI"} and \code{"PSOCK"}. Defaults to using the
\code{parallel} package default.}

\item{parallel.version.check}{Logical: If TRUE, check that the
version of \code{\link[=ergm-package]{ergm}} running on the slave
nodes is the same as that running on the master node.}

\item{\dots}{Additional arguments, passed to other functions This argument
is helpful because it collects any control parameters that have been
deprecated; a warning message is printed in case of deprecated arguments.}
}
\value{
A list with arguments as components.
}
\description{
Auxiliary function as user interface for fine-tuning 'stergm' fitting.
}
\details{
This function is only used within a call to the \code{\link{stergm}}
function.  See the \code{usage} section in \code{\link{stergm}} for details.
Generally speaking, \code{control.stergm} is remapped to \code{control.tergm},
with dissolution controls ignored and formation controls used as controls
for the overall \code{tergm} process.  An exception to this rule is the
initial parameter values specified via \code{init.form}, \code{init.diss},
\code{CMLE.form.ergm$init}, and \code{CMLE.diss.ergm$init}, which will be
remapped jointly with the \code{stergm()} arguments \code{offset.coef.form}
and \code{offset.coef.diss} to determine the initial parameter values passed
to \code{tergm}.

It is recommended that new code make use of \code{tergm} and \code{control.tergm}
directly; \code{stergm} wrappers are included only for backwards compatibility.
}
\references{
Boer, P., Huisman, M., Snijders,
T.A.B., and Zeggelink, E.P.H. (2003), StOCNET User\'s
Manual. Version 1.4.

Firth (1993), Bias Reduction in Maximum Likelihood Estimates.
Biometrika, 80: 27-38.

Hunter, D. R. and M. S. Handcock (2006), Inference in curved
exponential family models for networks. Journal of Computational and
Graphical Statistics, 15: 565-583.

Hummel, R. M., Hunter, D. R., and Handcock, M. S. (2010), A Steplength
Algorithm for Fitting ERGMs, Penn State Department of Statistics Technical
Report.
}
\seealso{
\code{\link{stergm}},\code{\link{tergm}},\code{\link{control.tergm}}. The
\code{\link{control.simulate.stergm}} function performs a similar
function for \code{\link{simulate.tergm}}.
}
