% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.duration.R
\name{nodemix.mean.age-ergmTerm}
\alias{nodemix.mean.age-ergmTerm}
\alias{InitErgmTerm.nodemix.mean.age}
\title{Average ages of extant ties of specified mixing types}
\usage{
# binary: nodemix.mean.age(attr, b1levels=NULL, b2levels=NULL, levels=NULL,
#                          levels2=NULL, emptyval=0, log=FALSE)
}
\arguments{
\item{attr}{quantitative attribute (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.)}

\item{b1levels, b2levels, levels, level2}{control what statistics are included in the model and the order in which they appear. \code{levels2} apply to all networks; \code{levels} applies to unipartite networks; \code{b1levels} and \code{b2levels} apply to bipartite networks (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details)}

\item{emptyval}{can be used to specify the value returned if the network is empty. A different value may be
specified for each mixing type of \code{attr}. The length of \code{emptyval} should either be 1 (in which case that value
is used for every mixing type of \code{attr} ) or should be equal to the number of retained mixing types of \code{attr} , in
which case the \code{i} th value in \code{emptyval} is used for the \code{i} th retained mixing type of \code{attr}. This is,
technically, an arbitrary value, but it should
not have a substantial effect unless a non-negligible fraction of
networks at the parameter configuration of interest is empty.}

\item{log}{logical specifying if mean log age should be returned instead of mean age}
}
\description{
Average ages of extant ties of specified mixing types
}
\details{
This term adds one statistic for each mixing type of \code{attr} ,
equaling the average, over all ties of that mixing type,
of the amount of time elapsed since formation.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.
}
\concept{durational}
