% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_ergm}
\alias{simulate_ergm}
\title{Fast Version of ergm::simulate.ergm for Edgelist-formatted Network}
\usage{
simulate_ergm(p, el, coef)
}
\arguments{
\item{p}{A list of network-related nodal covariates and related terms that
is produced with \code{\link{ergm_prep}}.}

\item{el}{A two-column matrix of current edges (edgelist) with an attribute
variable \code{n} containing the total current network size.}

\item{coef}{Vector of coefficients associated with the formation formula.}
}
\value{
Returns an updated network edgelist object, typically stored on the master
\code{dat} list object, based on the model simulation.
}
\description{
Resimulates a networkLite object given thin network data structure,
             edgelist, and ERGM model coefficients.
}
\details{
This function is used within the network resimulation module in \code{EpiModel}
to update cross-sectional ERGMs based on the model coefficients and current
network structure. If network structure (e.g., number of nodes) or nodal attributes
has changed since the last simulation, this network resimulation should be run
only after \code{\link{updateModelTermInputs}}.
}
\examples{
\dontrun{
library("EpiModel")

# Set seed for reproducibility
set.seed(1234)

nw <- network_initialize(100)
nw <- set_vertex_attribute(nw, "group", rep(1:2, each = 50))
formation <- ~edges + nodefactor("group")
target.stats <- c(15, 10)
coef.diss <- dissolution_coefs(dissolution = ~offset(edges), duration = 1)
x <- netest(nw, formation, target.stats, coef.diss, verbose = FALSE)

param <- param.net(inf.prob = 0.3, inf.prob.g2 = 0.1)
init <- init.net(i.num = 10, i.num.g2 = 10)
control <- control.net(type = "SI", nsteps = 100, nsims = 5, tergmLite = TRUE)

# Full network structure after initialization
dat <- crosscheck.net(x, param, init, control)
dat <- initialize.net(x, param, init, control)
str(dat, max.level = 1)

# Current network structure
dat$el[[1]]

# New network structure (all edges are new)
dat$el[[1]] <- simulate_ergm(p = dat$p[[1]],
                             el = dat$el[[1]],
                             coef = dat$nwparam[[1]]$coef.form)
dat$el[[1]]
}

}
