% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_regression.R
\name{tidy.glm}
\alias{tidy.glm}
\title{Custom Tidy Method for Binomial GLM Results}
\usage{
\method{tidy}{glm}(x, conf_level = 0.95, at = NULL, ...)
}
\arguments{
\item{x}{logistic regression model fitted by \code{\link[stats:glm]{stats::glm()}} with "binomial" family.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{at}{(\code{NULL} or \code{numeric})\cr optional values for the interaction variable. Otherwise the median is used.}

\item{...}{additional arguments for the lower level functions.}
}
\value{
A \code{data.frame} containing the tidied model.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Helper method (for \code{\link[broom:reexports]{broom::tidy()}}) to prepare a data frame from a \code{glm} object
with \code{binomial} family.
}
\examples{
library(dplyr)
library(broom)

adrs_f <- tern_ex_adrs \%>\%
  filter(PARAMCD == "BESRSPI") \%>\%
  filter(RACE \%in\% c("ASIAN", "WHITE", "BLACK OR AFRICAN AMERICAN")) \%>\%
  mutate(
    Response = case_when(AVALC \%in\% c("PR", "CR") ~ 1, TRUE ~ 0),
    RACE = factor(RACE),
    SEX = factor(SEX)
  )
formatters::var_labels(adrs_f) <- c(formatters::var_labels(tern_ex_adrs), Response = "Response")
mod1 <- fit_logistic(
  data = adrs_f,
  variables = list(
    response = "Response",
    arm = "ARMCD",
    covariates = c("AGE", "RACE")
  )
)
mod2 <- fit_logistic(
  data = adrs_f,
  variables = list(
    response = "Response",
    arm = "ARMCD",
    covariates = c("AGE", "RACE"),
    interaction = "AGE"
  )
)

df <- tidy(mod1, conf_level = 0.99)
df2 <- tidy(mod2, conf_level = 0.99)

}
\seealso{
\link{h_logistic_regression} for relevant helper functions.
}
