% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odds_ratio.R
\name{odds_ratio}
\alias{odds_ratio}
\alias{estimate_odds_ratio}
\alias{s_odds_ratio}
\alias{a_odds_ratio}
\title{Odds Ratio Estimation}
\usage{
estimate_odds_ratio(
  lyt,
  vars,
  variables = list(arm = NULL, strata = NULL),
  conf_level = 0.95,
  groups_list = NULL,
  na_str = default_na_str(),
  nested = TRUE,
  ...,
  show_labels = "hidden",
  table_names = vars,
  .stats = "or_ci",
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)

s_odds_ratio(
  df,
  .var,
  .ref_group,
  .in_ref_col,
  .df_row,
  variables = list(arm = NULL, strata = NULL),
  conf_level = 0.95,
  groups_list = NULL
)

a_odds_ratio(
  df,
  .var,
  .ref_group,
  .in_ref_col,
  .df_row,
  variables = list(arm = NULL, strata = NULL),
  conf_level = 0.95,
  groups_list = NULL
)
}
\arguments{
\item{lyt}{(\code{layout})\cr input layout where analyses will be added to.}

\item{vars}{(\code{character})\cr variable names for the primary analysis variable to be iterated over.}

\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{groups_list}{(named \code{list} of \code{character})\cr specifies the new group levels via the names and the
levels that belong to it in the character vectors that are elements of the list.}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{nested}{(\code{flag})\cr whether this layout instruction should be applied within the existing layout structure \emph{if
possible} (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split.
underneath analyses, which is not allowed.}

\item{...}{arguments passed to \code{s_odds_ratio()}.}

\item{show_labels}{(\code{string})\cr label visibility: one of "default", "visible" and "hidden".}

\item{table_names}{(\code{character})\cr this can be customized in case that the same \code{vars} are analyzed multiple times,
to avoid warnings from \code{rtables}.}

\item{.stats}{(\code{character})\cr statistics to select for the table. Run \code{get_stats("estimate_odds_ratio")}
to see available statistics for this function.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{"auto"} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{.ref_group}{(\code{data.frame} or \code{vector})\cr the data corresponding to the reference group.}

\item{.in_ref_col}{(\code{logical})\cr \code{TRUE} when working with the reference level, \code{FALSE} otherwise.}

\item{.df_row}{(\code{data.frame})\cr data frame across all of the columns for the given row split.}
}
\value{
\itemize{
\item \code{estimate_odds_ratio()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_odds_ratio()} to the table layout.
}

\itemize{
\item \code{s_odds_ratio()} returns a named list with the statistics \code{or_ci}
(containing \code{est}, \code{lcl}, and \code{ucl}) and \code{n_tot}.
}

\itemize{
\item \code{a_odds_ratio()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Compares bivariate responses between two groups in terms of odds ratios
along with a confidence interval.
}
\details{
This function uses either logistic regression for unstratified
analyses, or conditional logistic regression for stratified analyses.
The Wald confidence interval with the specified confidence level is
calculated.
}
\section{Functions}{
\itemize{
\item \code{estimate_odds_ratio()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

\item \code{s_odds_ratio()}: Statistics function which estimates the odds ratio
between a treatment and a control. A \code{variables} list with \code{arm} and \code{strata}
variable names must be passed if a stratified analysis is required.

\item \code{a_odds_ratio()}: Formatted analysis function which is used as \code{afun} in \code{estimate_odds_ratio()}.

}}
\note{
For stratified analyses, there is currently no implementation for conditional
likelihood confidence intervals, therefore the likelihood confidence interval is not
yet available as an option. Besides, when \code{rsp} contains only responders or non-responders,
then the result values will be \code{NA}, because no odds ratio estimation is possible.
}
\examples{
set.seed(12)
dta <- data.frame(
  rsp = sample(c(TRUE, FALSE), 100, TRUE),
  grp = factor(rep(c("A", "B"), each = 50), levels = c("A", "B")),
  strata = factor(sample(c("C", "D"), 100, TRUE))
)

l <- basic_table() \%>\%
  split_cols_by(var = "grp", ref_group = "B") \%>\%
  estimate_odds_ratio(vars = "rsp")

build_table(l, df = dta)

# Unstratified analysis.
s_odds_ratio(
  df = subset(dta, grp == "A"),
  .var = "rsp",
  .ref_group = subset(dta, grp == "B"),
  .in_ref_col = FALSE,
  .df_row = dta
)

# Stratified analysis.
s_odds_ratio(
  df = subset(dta, grp == "A"),
  .var = "rsp",
  .ref_group = subset(dta, grp == "B"),
  .in_ref_col = FALSE,
  .df_row = dta,
  variables = list(arm = "grp", strata = "strata")
)

a_odds_ratio(
  df = subset(dta, grp == "A"),
  .var = "rsp",
  .ref_group = subset(dta, grp == "B"),
  .in_ref_col = FALSE,
  .df_row = dta
)

}
\seealso{
Relevant helper function \code{\link[=h_odds_ratio]{h_odds_ratio()}}.
}
