% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response_subgroups.R
\name{response_subgroups}
\alias{response_subgroups}
\alias{tabulate_rsp_subgroups}
\alias{a_response_subgroups}
\title{Tabulate binary response by subgroup}
\usage{
tabulate_rsp_subgroups(
  lyt,
  df,
  vars = c("n_tot", "n", "prop", "or", "ci"),
  groups_lists = list(),
  label_all = "All Patients",
  na_str = default_na_str()
)

a_response_subgroups(
  .formats = list(n = "xx", n_rsp = "xx", prop = "xx.x\%", n_tot = "xx", or =
    list(format_extreme_values(2L)), ci = list(format_extreme_values_ci(2L)), pval =
    "x.xxxx | (<0.0001)"),
  na_str = default_na_str()
)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout that analyses will be added to.}

\item{df}{(\code{list})\cr of data frames containing all analysis variables. List should be
created using \code{\link[=extract_rsp_subgroups]{extract_rsp_subgroups()}}.}

\item{vars}{(\code{character})\cr the names of statistics to be reported among:
\itemize{
\item \code{n}: Total number of observations per group.
\item \code{n_rsp}: Number of responders per group.
\item \code{prop}: Proportion of responders.
\item \code{n_tot}: Total number of observations.
\item \code{or}: Odds ratio.
\item \code{ci} : Confidence interval of odds ratio.
\item \code{pval}: p-value of the effect.
Note, the statistics \code{n_tot}, \code{or} and \code{ci} are required.
}}

\item{groups_lists}{(named \code{list} of \code{list})\cr optionally contains for each \code{subgroups} variable a
list, which specifies the new group levels via the names and the
levels that belong to it in the character vectors that are elements of the list.}

\item{label_all}{(\code{string})\cr label for the total population analysis.}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{"auto"} setting.}
}
\value{
An \code{rtables} table summarizing binary response by subgroup.

\itemize{
\item \code{a_response_subgroups()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Tabulate statistics such as response rate and odds ratio for population subgroups.
}
\details{
These functions create a layout starting from a data frame which contains
the required statistics. Tables typically used as part of forest plot.
}
\section{Functions}{
\itemize{
\item \code{tabulate_rsp_subgroups()}: Table-creating function which creates a table
summarizing binary response by subgroup. This function is a wrapper for \code{\link[rtables:analyze_colvars]{rtables::analyze_colvars()}}
and \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}.

\item \code{a_response_subgroups()}: Formatted analysis function which is used as \code{afun} in \code{tabulate_rsp_subgroups()}.

}}
\examples{
library(dplyr)
library(forcats)

adrs <- tern_ex_adrs
adrs_labels <- formatters::var_labels(adrs)

adrs_f <- adrs \%>\%
  filter(PARAMCD == "BESRSPI") \%>\%
  filter(ARM \%in\% c("A: Drug X", "B: Placebo")) \%>\%
  droplevels() \%>\%
  mutate(
    # Reorder levels of factor to make the placebo group the reference arm.
    ARM = fct_relevel(ARM, "B: Placebo"),
    rsp = AVALC == "CR"
  )
formatters::var_labels(adrs_f) <- c(adrs_labels, "Response")

# Unstratified analysis.
df <- extract_rsp_subgroups(
  variables = list(rsp = "rsp", arm = "ARM", subgroups = c("SEX", "BMRKR2")),
  data = adrs_f
)
df

# Stratified analysis.
df_strat <- extract_rsp_subgroups(
  variables = list(rsp = "rsp", arm = "ARM", subgroups = c("SEX", "BMRKR2"), strata = "STRATA1"),
  data = adrs_f
)
df_strat

# Grouping of the BMRKR2 levels.
df_grouped <- extract_rsp_subgroups(
  variables = list(rsp = "rsp", arm = "ARM", subgroups = c("SEX", "BMRKR2")),
  data = adrs_f,
  groups_lists = list(
    BMRKR2 = list(
      "low" = "LOW",
      "low/medium" = c("LOW", "MEDIUM"),
      "low/medium/high" = c("LOW", "MEDIUM", "HIGH")
    )
  )
)
df_grouped

## Table with default columns.
basic_table() \%>\%
  tabulate_rsp_subgroups(df)

## Table with selected columns.
basic_table() \%>\%
  tabulate_rsp_subgroups(
    df = df,
    vars = c("n_tot", "n", "n_rsp", "prop", "or", "ci")
  )

}
\seealso{
\code{\link[=extract_rsp_subgroups]{extract_rsp_subgroups()}}
}
\keyword{internal}
