% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abnormal.R
\name{abnormal}
\alias{abnormal}
\alias{count_abnormal}
\alias{s_count_abnormal}
\alias{a_count_abnormal}
\title{Count patients with abnormal range values}
\usage{
count_abnormal(
  lyt,
  var,
  abnormal = list(Low = "LOW", High = "HIGH"),
  variables = list(id = "USUBJID", baseline = "BNRIND"),
  exclude_base_abn = FALSE,
  na_str = default_na_str(),
  nested = TRUE,
  ...,
  table_names = var,
  .stats = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)

s_count_abnormal(
  df,
  .var,
  abnormal = list(Low = "LOW", High = "HIGH"),
  variables = list(id = "USUBJID", baseline = "BNRIND"),
  exclude_base_abn = FALSE
)

a_count_abnormal(
  df,
  .var,
  abnormal = list(Low = "LOW", High = "HIGH"),
  variables = list(id = "USUBJID", baseline = "BNRIND"),
  exclude_base_abn = FALSE
)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout that analyses will be added to.}

\item{abnormal}{(named \code{list})\cr list identifying the abnormal range level(s) in \code{var}. Defaults to
\code{list(Low = "LOW", High = "HIGH")} but you can also group different levels into the named list,
for example, \code{abnormal = list(Low = c("LOW", "LOW LOW"), High = c("HIGH", "HIGH HIGH"))}.}

\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables.}

\item{exclude_base_abn}{(\code{flag})\cr whether to exclude subjects with baseline abnormality
from numerator and denominator.}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{nested}{(\code{flag})\cr whether this layout instruction should be applied within the existing layout structure _if
possible (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split.
underneath analyses, which is not allowed.}

\item{...}{additional arguments for the lower level functions.}

\item{table_names}{(\code{character})\cr this can be customized in the case that the same \code{vars} are analyzed multiple
times, to avoid warnings from \code{rtables}.}

\item{.stats}{(\code{character})\cr statistics to select for the table.

Options are: \code{'fraction'}}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{"auto"} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var, var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}
}
\value{
\itemize{
\item \code{count_abnormal()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_count_abnormal()} to the table layout.
}

\itemize{
\item \code{s_count_abnormal()} returns the statistic \code{fraction} which is a vector with \code{num} and \code{denom} counts of patients.
}

\itemize{
\item \code{a_count_abnormal()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The analyze function \code{\link[=count_abnormal]{count_abnormal()}} creates a layout element to count patients with abnormal analysis range
values in each direction.

This function analyzes primary analysis variable \code{var} which indicates abnormal range results.
Additional analysis variables that can be supplied as a list via the \code{variables} parameter are
\code{id} (defaults to \code{USUBJID}), a variable to indicate unique subject identifiers, and \code{baseline}
(defaults to \code{BNRIND}), a variable to indicate baseline reference ranges.

For each direction specified via the \code{abnormal} parameter (e.g. High or Low), a fraction of
patient counts is returned, with numerator and denominator calculated as follows:
\itemize{
\item \code{num}: The number of patients with this abnormality recorded while on treatment.
\item \code{denom}: The total number of patients with at least one post-baseline assessment.
}

This function assumes that \code{df} has been filtered to only include post-baseline records.
}
\section{Functions}{
\itemize{
\item \code{count_abnormal()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

\item \code{s_count_abnormal()}: Statistics function which counts patients with abnormal range values
for a single \code{abnormal} level.

\item \code{a_count_abnormal()}: Formatted analysis function which is used as \code{afun} in \code{count_abnormal()}.

}}
\note{
\itemize{
\item \code{count_abnormal()} only considers a single variable that contains multiple abnormal levels.
\item \code{df} should be filtered to only include post-baseline records.
\item The denominator includes patients that may have other abnormal levels at baseline,
and patients missing baseline records. Patients with these abnormalities at
baseline can be optionally excluded from numerator and denominator via the
\code{exclude_base_abn} parameter.
}
}
\examples{
library(dplyr)

df <- data.frame(
  USUBJID = as.character(c(1, 1, 2, 2)),
  ANRIND = factor(c("NORMAL", "LOW", "HIGH", "HIGH")),
  BNRIND = factor(c("NORMAL", "NORMAL", "HIGH", "HIGH")),
  ONTRTFL = c("", "Y", "", "Y"),
  stringsAsFactors = FALSE
)

# Select only post-baseline records.
df <- df \%>\%
  filter(ONTRTFL == "Y")

# Layout creating function.
basic_table() \%>\%
  count_abnormal(var = "ANRIND", abnormal = list(high = "HIGH", low = "LOW")) \%>\%
  build_table(df)

# Passing of statistics function and formatting arguments.
df2 <- data.frame(
  ID = as.character(c(1, 1, 2, 2)),
  RANGE = factor(c("NORMAL", "LOW", "HIGH", "HIGH")),
  BL_RANGE = factor(c("NORMAL", "NORMAL", "HIGH", "HIGH")),
  ONTRTFL = c("", "Y", "", "Y"),
  stringsAsFactors = FALSE
)

# Select only post-baseline records.
df2 <- df2 \%>\%
  filter(ONTRTFL == "Y")

basic_table() \%>\%
  count_abnormal(
    var = "RANGE",
    abnormal = list(low = "LOW", high = "HIGH"),
    variables = list(id = "ID", baseline = "BL_RANGE")
  ) \%>\%
  build_table(df2)

}
\keyword{internal}
