\name{test_that}
\alias{test_that}
\title{Create a test.}
\usage{
  test_that(desc, code)
}
\arguments{
  \item{desc}{test name.  Names should be kept as brief as
  possible, as they are often used as line prefixes.}

  \item{code}{test code containing expectations}
}
\description{
  A test encapsulates a series of expectations about small,
  self-contained set of functionality.  Each test is
  contained in a \link{context} and contains multiple
  expectation generated by \code{\link{expect_that}}.
}
\details{
  Tests are evaluated in their own environments, and should
  not affect global state.

  When run from the command line, tests return \code{NULL}
  if all expectations are met, otherwise it raises an
  error.
}
\examples{
test_that("trigonometric functions match identies", {
  expect_that(sin(pi / 4), equals(1 / sqrt(2)))
  expect_that(cos(pi / 4), equals(1 / sqrt(2)))
  expect_that(tan(pi / 4), equals(1))
})
# Failing test:
\dontrun{
test_that("trigonometric functions match identities", {
  expect_that(sin(pi / 4), equals(1))
})
}
}

