% Generated by roxygen2 (4.0.2): do not edit by hand
\name{has_names}
\alias{expect_named}
\alias{has_names}
\title{Expectation: does object have names?}
\usage{
has_names(expected, ignore.order = FALSE, ignore.case = FALSE)

expect_named(object, expected, ..., info = NULL, label = NULL)
}
\arguments{
\item{expected}{Character vector of expected names. Leave missing to
match any names. Use \code{NULL} to check for absence of names.}

\item{ignore.order}{If \code{TRUE}, sorts names before comparing to
ignore the effect of order.}

\item{ignore.case}{If \code{TRUE}, lowercases all names to ignore the
effect of case.}

\item{object}{object to test}

\item{...}{Other arguments passed onto \code{has_names}.}

\item{info}{extra information to be included in the message (useful when
writing tests in loops).}

\item{label}{object label. When \code{NULL}, computed from deparsed object.}
}
\description{
You can either check for the presence of names (leaving \code{expected}
blank), specific names (by suppling a vector of names), or absence of
names (with \code{NULL}).
}
\examples{
x <- c(a = 1, b = 2, c = 3)
expect_named(x)
expect_named(x, c("a", "b", "c"))

# Use options to control sensitivity
expect_named(x, c("B", "C", "A"), ignore.order = TRUE, ignore.case = TRUE)

# Can also check for the absence of names with NULL
z <- 1:4
expect_named(z, NULL)
}
\seealso{
Other expectations: \code{\link{equals_reference}},
  \code{\link{expect_equal_to_reference}};
  \code{\link{equals}}, \code{\link{expect_equal}};
  \code{\link{expect-compare}},
  \code{\link{expect_less_than}},
  \code{\link{expect_more_than}},
  \code{\link{is_less_than}}, \code{\link{is_more_than}};
  \code{\link{expect_equivalent}},
  \code{\link{is_equivalent_to}};
  \code{\link{expect_error}}, \code{\link{throws_error}};
  \code{\link{expect_false}}, \code{\link{expect_true}},
  \code{\link{is_false}}, \code{\link{is_true}};
  \code{\link{expect_identical}},
  \code{\link{is_identical_to}}; \code{\link{expect_is}},
  \code{\link{is_a}}; \code{\link{expect_match}},
  \code{\link{matches}}; \code{\link{expect_message}},
  \code{\link{shows_message}}; \code{\link{expect_null}},
  \code{\link{is_null}}; \code{\link{expect_output}},
  \code{\link{prints_text}}; \code{\link{expect_warning}},
  \code{\link{gives_warning}};
  \code{\link{takes_less_than}}
}

