% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-compiled-code.R
\name{use_catch}
\alias{use_catch}
\title{Use Catch for C++ Unit Testing}
\usage{
use_catch(dir = getwd())
}
\arguments{
\item{dir}{The directory containing an \R package.}
}
\description{
Add the necessary infrastructure to enable C++ unit testing
in \R packages with
\href{https://github.com/philsquared/Catch}{Catch} and \code{testthat}.
}
\details{
Calling \code{use_catch()} will:

\enumerate{

\item Create a file \code{src/test-runner.cpp}, which ensures that the
        \code{testthat} package will understand how to run your package's
        unit tests,

\item Create an example test file \code{src/test-example.cpp}, which
        showcases how you might use Catch to write a unit test, and

\item Add a test file \code{tests/testthat/test-cpp.R}, which ensures that
        \code{testthat} will run your compiled tests.
}

C++ unit tests can be added to C++ source files within the
\code{src/} directory of your package, with a format similar
to \R code tested with \code{testthat} -- for example,

\preformatted{
context("C++ Unit Test") {
  test_that("two plus two is four") {
    int result = 2 + 2;
    expect_true(result == 4);
  }
}
}

When your package is compiled, unit tests alongside a harness
for running these tests will be compiled into your \R package,
with the C entry point \code{run_testthat_tests()}. \code{testthat}
will use that entry point to run your unit tests when detected.
}
\section{Functions}{


All of the functions provides by Catch are
available with the \code{CATCH_} prefix -- see
\href{https://github.com/philsquared/Catch/blob/master/docs/assertions.md}{here}
for a full list. \code{testthat} provides the
following wrappers, to conform with \code{testthat}'s
\R interface:

\tabular{lll}{
\strong{Function} \tab \strong{Catch} \tab \strong{Description} \cr
\code{context} \tab \code{CATCH_TEST_CASE} \tab The context of a set of tests. \cr
\code{test_that} \tab \code{CATCH_SECTION} \tab A test section. \cr
\code{expect_true} \tab \code{CATCH_CHECK} \tab Test that an expression evaluates to \code{true}. \cr
\code{expect_false} \tab \code{CATCH_CHECK_FALSE} \tab Test that an expression evalutes to \code{false}. \cr
\code{expect_error} \tab \code{CATCH_CHECK_THROWS} \tab Test that evaluation of an expression throws an error. \cr
\code{expect_error_as} \tab \code{CATCH_CHECK_THROWS_AS} \tab Test that evaluation of an expression throws an error of a specific class. \cr
}
}

\section{Advanced Usage}{


If you'd like to write your own Catch test runner, you can
instead use the \code{testthat::catchSession()} object in a file
with the form:

\preformatted{
#define TESTTHAT_TEST_RUNNER
#include <testthat.h>

void run()
{
    Catch::Session& session = testthat::catchSession();
    // interact with the session object as desired
}
}

This can be useful if you'd like to run your unit tests
with custom arguments passed to the Catch session.
}
\seealso{
\href{https://github.com/philsquared/Catch}{Catch}, the
  library used to enable C++ unit testing.
}

