% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R, R/tetragon.R
\docType{package}
\name{tetragon}
\alias{tetragon}
\alias{tetragon-package}
\title{tetragon}
\usage{
tetragon(
  df,
  seq_len = NULL,
  ci = 0.8,
  method = NULL,
  distr = NULL,
  n_windows = 3,
  n_sample = 30,
  dates = NULL,
  error_scale = "naive",
  error_benchmark = "naive",
  seed = 42
)
}
\arguments{
\item{df}{A data frame with time features as columns. They could be continuous variables or not.}

\item{seq_len}{Positive integer. Time-step number of the projected sequence. Default: NULL (random selection between maximum boundaries).}

\item{ci}{Confidence interval. Default: 0.8.}

\item{method}{String. Distance method for calculating distance matrix among sequences. Options are: "euclidean", "manhattan", "maximum", "minkowski". Default: NULL (random selection among all possible options).}

\item{distr}{String. Distribution used to expand the distance matrix. Options are: "norm", "logis", "t", "exp", "chisq". Default: NULL (random selection among all possible options).}

\item{n_windows}{Positive integer. Number of validation tests to measure/sample error. Default: 3 (but a larger value is strongly suggested to really understand your accuracy).}

\item{n_sample}{Positive integer. Number of samples for random search. Default: 30.}

\item{dates}{Date. Vector with dates for time features.}

\item{error_scale}{String. Scale for the scaled error metrics (only for continuous variables). Two options: "naive" (average of naive one-step absolute error for the historical series) or "deviation" (standard error of the historical series). Default: "naive".}

\item{error_benchmark}{String. Benchmark for the relative error metrics (only for continuous variables). Two options: "naive" (sequential extension of last value) or "average" (mean value of true sequence). Default: "naive".}

\item{seed}{Positive integer. Random seed. Default: 42.}
}
\value{
This function returns a list including:
\itemize{
\item exploration: list of all explored models, complete with predictions, testing metrics and plots
\item history: a table with the sampled models, hyper-parameters, validation errors
\item best: results for the best model including:
\itemize{
\item predictions: min, max, q25, q50, q75, quantiles at selected ci, and a bunch of specific measures for each point fo predicted sequences
\item testing_errors: testing errors for one-step and sequence for each ts feature
\item plots: confidence interval plot for each time feature
}
\item time_log
}
}
\description{
Each sequence is predicted by expanding the distance matrix. The compact set of hyper-parameters is tuned via grid or random search.
}
\examples{
\donttest{
tetragon(covid_in_europe[, c(2, 4)], seq_len = 40, n_sample = 2)
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://rpubs.com/giancarlo_vercellino/tetragon}
}

}
\author{
Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com}
}
