% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.evm.R
\name{plot.evmOpt}
\alias{plot.evmOpt}
\title{Plots for evmOpt objects}
\usage{
\method{plot}{evmOpt}(x, main = rep(NULL, 4), xlab = rep(NULL, 4),
  nsim = 1000, alpha = 0.05, ...)
}
\arguments{
\item{x}{an object of class \code{evmOpt}}

\item{main}{titles for diagnostic plots. Should be a vector of
length 4, with values corresponding to the character strings to
appear on the titles of the pp, qq, return level, and density
estimate plots respectively.}

\item{xlab}{As for \code{main} but labels for x-axes rather than
titles.}

\item{nsim}{The number of replicates to be simulated to produce the
simulated tolerance intervals.}

\item{alpha}{A \eqn{100(1 - \alpha)\%}{100(1 - alpha)\%} simulation
envelope is produced.}

\item{...}{FIXME}
}
\description{
Various plots for \code{evmOpt} objects. These differ depending on
whether or not there are covariates in the model.  If there are no
covariates then the diagnostic plots are PP- and QQ-plots, a return
level plot (produced by \code{plotrl.evmSim}) and a histogram of
the data with superimposed density estimate.  These are all
calculated using the data on the original scale. If there are
covariates in the model then the diagnostics consist of PP- and QQ-
plots calculated by using the model residuals (which will be
standard exponential devaiates under the GPD model and standard
Gumbel deviates under the GEV model), and plots of residuals versus
fitted model parameters.
}
\details{
The PP- and QQ-plots show simulated pointwise tolerance intervals.
The region is a \eqn{100(1 - \alpha)\%}{100(1-alpha)\%} region based
on \code{nsim} simulated samples.
}
\seealso{
\code{\link{evm}}
}

