% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copulas.R
\name{copula}
\alias{copula}
\alias{plot.copula}
\alias{print.copula}
\title{Calculate the copula of a matrix of variables}
\usage{
copula(x, na.last = NA)
\method{plot}{copula}(x, jitter. = FALSE, jitter.factor=1, ...)
\method{print}{copula}(x, ...)
}
\arguments{
\item{x}{A matrix or data.frame containing numeric variables.}

\item{na.last}{How to treat missing values. See \code{rank} for details.}

\item{jitter.}{In the call to \code{plot.copula}, if \code{jitter=TRUE}, the
values are jittered before plotting. Defaults to \code{jitter. = FALSE}.}

\item{jitter.factor}{How much jittering to use. Defaults to
\code{jitter.factor = 1.}}

\item{...}{Further arguments to be passed to plot method.}
}
\value{
A matrix with the same dimensions as \code{x}, each column of which
contains the quantiles of each column of \code{x}. This object is of class
\code{copula}.
}
\description{
Returns the copula of several random variables.
}
\details{
The result is obtained by applying \code{\link{edf}} to each column of
\code{x} in turn.

Print and plot methods are available for the copula class.
}
\examples{

  D <- liver[liver$dose == "D",]
  Dco <- copula(D)
  plot(Dco)

}
\seealso{
\code{\link{edf}}
}
\author{
Harry Southworth
}
\keyword{multivariate}
