% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,Sarlm-method}
\alias{extract,Sarlm-method}
\alias{extract.Sarlm}
\title{\code{\link{extract}} method for \code{Sarlm} objects}
\usage{
\S4method{extract}{Sarlm}(
  model,
  include.nobs = TRUE,
  include.loglik = TRUE,
  include.aic = TRUE,
  include.lr = TRUE,
  include.wald = TRUE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{include.nobs}{Report the number of observations in the GOF block?}

\item{include.loglik}{Report the log likelihood in the GOF block?}

\item{include.aic}{Report Akaike's Information Criterion (AIC) in the GOF
block?}

\item{include.lr}{Report likelihood ratio test?}

\item{include.wald}{Report the Wald statistic?}

\item{...}{Custom parameters, which are handed over to subroutines, in this
case to the \code{summary} method for the object.}
}
\description{
\code{\link{extract}} method for \code{Sarlm} objects created by the
\code{\link[spatialreg:ML_models]{lagsarlm}} function in the \pkg{spatialreg}
package.
}
