% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_1_textEmbed.R
\name{textDimName}
\alias{textDimName}
\title{Change dimension names}
\usage{
textDimName(word_embeddings, dim_names = TRUE, name = NULL)
}
\arguments{
\item{word_embeddings}{List of word embeddings or a single tibble}

\item{dim_names}{Logical. If TRUE, the word embedding name or a custom name will be attached to the name of each dimension.
If FALSE, the attached part of the name will be removed.}

\item{name}{Optional character. If provided and dim_names = TRUE, this custom name will be attached after each column (e.g., dim1_name).}
}
\value{
Word embeddings with changed names.
}
\description{
textDimName() changes the names of the dimensions in the word embeddings.
}
\examples{
\donttest{
# Note that dimensions are called Dim1_harmonytexts etc.
word_embeddings_4$texts$harmonytexts

# Change to just Dim
w_e_T <- textDimName(word_embeddings_4$texts["harmonytexts"],
  dim_names = FALSE
)

# Change back to include the original name
w_e_F <- textDimName(w_e_T, dim_names = TRUE)

# Change and add a custom name
w_e_custom <- textDimName(w_e_T, dim_names = TRUE, name = "CustomName")
}
}
\seealso{
\code{\link{textEmbed}}
}
