% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_2_textPlotPCA.R
\name{textPCAPlot}
\alias{textPCAPlot}
\title{textPCAPlot}
\usage{
textPCAPlot(
  word_data,
  min_freq_words_test = 1,
  plot_n_word_extreme = 5,
  plot_n_word_frequency = 5,
  plot_n_words_middle = 5,
  titles_color = "#61605e",
  title_top = "Principal Component (PC) Plot",
  x_axes_label = "PC1",
  y_axes_label = "PC2",
  scale_x_axes_lim = NULL,
  scale_y_axes_lim = NULL,
  word_font = NULL,
  bivariate_color_codes = c("#398CF9", "#60A1F7", "#5dc688", "#e07f6a", "#EAEAEA",
    "#40DD52", "#FF0000", "#EA7467", "#85DB8E"),
  word_size_range = c(3, 8),
  position_jitter_hight = 0,
  position_jitter_width = 0.03,
  point_size = 0.5,
  arrow_transparency = 0.1,
  points_without_words_size = 0.2,
  points_without_words_alpha = 0.2,
  legend_title = "PC",
  legend_x_axes_label = "PC1",
  legend_y_axes_label = "PC2",
  legend_x_position = 0.02,
  legend_y_position = 0.02,
  legend_h_size = 0.2,
  legend_w_size = 0.2,
  legend_title_size = 7,
  legend_number_size = 2,
  seed = 1002
)
}
\arguments{
\item{word_data}{Dataframe from textPCA}

\item{min_freq_words_test}{Select words to significance test that have occurred at least min_freq_words_test
(default = 1).}

\item{plot_n_word_extreme}{Number of words that are extreme on Supervised Dimension Projection per dimension.
(i.e., even if not significant; per dimensions, where duplicates are removed).}

\item{plot_n_word_frequency}{Number of words based on being most frequent.
(i.e., even if not significant).}

\item{plot_n_words_middle}{Number of words plotted that are in the middle in Supervised Dimension Projection score
(i.e., even if not significant;  per dimensions, where duplicates are removed).}

\item{titles_color}{Color for all the titles (default: "#61605e")}

\item{title_top}{Title (default "  ")}

\item{x_axes_label}{Label on the x-axes.}

\item{y_axes_label}{Label on the y-axes.}

\item{scale_x_axes_lim}{Manually set the length of the x-axes (default = NULL, which uses
ggplot2::scale_x_continuous(limits = scale_x_axes_lim); change e.g., by trying c(-5, 5)).}

\item{scale_y_axes_lim}{Manually set the length of the y-axes (default = NULL; which uses
ggplot2::scale_y_continuous(limits = scale_y_axes_lim); change e.g., by trying c(-5, 5)).}

\item{word_font}{Font type (default: NULL).}

\item{bivariate_color_codes}{The different colors of the words
(default: c("#398CF9", "#60A1F7", "#5dc688",
"#e07f6a", "#EAEAEA", "#40DD52",
"#FF0000", "#EA7467", "#85DB8E")).}

\item{word_size_range}{Vector with minimum and maximum font size (default: c(3, 8)).}

\item{position_jitter_hight}{Jitter height (default: .0).}

\item{position_jitter_width}{Jitter width (default: .03).}

\item{point_size}{Size of the points indicating the words' position (default: 0.5).}

\item{arrow_transparency}{Transparency of the lines between each word and point (default: 0.1).}

\item{points_without_words_size}{Size of the points not linked with a words
(default is to not show it, i.e., 0).}

\item{points_without_words_alpha}{Transparency of the points not linked with a words
(default is to not show it, i.e., 0).}

\item{legend_title}{Title on the color legend (default: "(PCA)".}

\item{legend_x_axes_label}{Label on the color legend (default: "(x)".}

\item{legend_y_axes_label}{Label on the color legend (default: "(y)".}

\item{legend_x_position}{Position on the x coordinates of the color legend (default: 0.02).}

\item{legend_y_position}{Position on the y coordinates of the color legend (default: 0.05).}

\item{legend_h_size}{Height of the color legend (default 0.15).}

\item{legend_w_size}{Width of the color legend (default 0.15).}

\item{legend_title_size}{Font size (default: 7).}

\item{legend_number_size}{Font size of the values in the legend (default: 2).}

\item{seed}{Set different seed.}
}
\value{
A 1- or 2-dimensional word plot, as well as tibble with processed data used to plot..
}
\description{
textPCAPlot() plots words according to 2-D plot from 2 PCA components.
}
\examples{
# The test-data included in the package is called: DP_projections_HILS_SWLS_100

# Supervised Dimension Projection Plot
principle_component_plot_projection <- textPCAPlot(PC_projections_satisfactionwords_40)
principle_component_plot_projection

names(DP_projections_HILS_SWLS_100)
}
\seealso{
see \code{\link{textPCA}}
}
