% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_4_0_textPredict_Assess_Classify.R
\name{textLBAM}
\alias{textLBAM}
\title{The LBAM library}
\usage{
textLBAM(columns = NULL, construct_start = NULL, lbam_update = FALSE)
}
\arguments{
\item{columns}{(string) Select which columns to retrieve e.g., c("Name", "Path")}

\item{construct_start}{(string) Select which constructs concepts and/or behaviors to retrieve.}

\item{lbam_update}{(boolean) TRUE downloads a new copy of the LBAM file}
}
\value{
Data frame containing information about the Language-based assessment models library (LBAM).
}
\description{
Retrieve the Language-Based Assessment Models library (LBAM).
}
\examples{
\dontrun{
library(dplyr)
test_lbam <- textLBAM(
  lbam_update = TRUE
)
subset(
  lbam,
  substr(Construct_Concept_Behaviours, 1, 3) == "Dep",
  select = c(Construct_Concept_Behaviours, Name)
)

}
}
