% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_any.R
\name{detect_any}
\alias{detect_any}
\title{Detect SDGs in text with own query system}
\usage{
detect_any(
  text,
  system,
  queries = lifecycle::deprecated(),
  sdgs = NULL,
  output = c("features", "documents"),
  verbose = TRUE
)
}
\arguments{
\item{text}{\code{character} vector or object of class \code{tCorpus} containing text in which SDGs shall be detected.}

\item{system}{a data frame that must contain the following variables: a \code{character} vector with queries, a \code{integer} vector specifying which SDG each query maps to (values must be between 1 and 17) and a \code{character} with one unique value specifying the name of the used query system (can be anything as long as it is unique).}

\item{queries}{deprecated.}

\item{sdgs}{\code{numeric} vector with integers between 1 and 17 specifying the sdgs to identify in \code{text}. Defaults to \code{1:17}.}

\item{output}{\code{character} specifying the level of detail in the output. The default \code{"features"} returns a \code{tibble} with one row per matched query, include a variable containing the features of the query that were matched in the text. By contrast, \code{"documents"} returns an aggregated \code{tibble} with one row per matched sdg, without information on the features.}

\item{verbose}{\code{logical} specifying whether messages on the function's progress should be printed.}
}
\value{
The function returns a \code{tibble} containing the SDG hits found in the vector of documents. Depending on the value of \code{output} the tibble will contain all or some of the following columns:
\describe{
 \item{document}{Index of the element in \code{text} where match was found. Formatted as a factor with the number of levels matching the original number of documents.}
 \item{sdg}{Label of the SDG found in document.}
 \item{systems}{The name of the query system that produced the match.}
 \item{query_id}{Index of the query within the query system that produced the match.}
 \item{features}{Concatenated list of words that caused the query to match.}
 \item{hit}{Index of hit for a given system.}
}
}
\description{
\code{detect_any} identifies SDGs in text using user provided query systems. Works like \code{\link{detect_sdg}} but uses a user specified query system instead of an existing one like \code{\link{detect_sdg}} does.
}
\examples{
\donttest{
# create data frame with query system
my_queries <- tibble::tibble(system = "my_system",
                             query = c("theory",
                                       "analysis OR analyses OR analyzed",
                                       "study AND hypothesis"),
                             sdg = c(1,2,2))

# run sdg detection with own query system
hits <- detect_any(projects, my_queries)

# run sdg detection for sdg 2 only
hits <- detect_any(projects, my_queries, sdgs = 2)
}

}
