% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_emoji.R
\name{replace_emoji}
\alias{replace_emoji}
\alias{replace_emoji_identifier}
\title{Replace Emojis With Words/Identifier}
\usage{
replace_emoji(x, emoji_dt = lexicon::hash_emojis, ...)

replace_emoji_identifier(x, emoji_dt = lexicon::hash_emojis_identifier, ...)
}
\arguments{
\item{x}{The text variable.}

\item{emoji_dt}{A \pkg{data.table} of emojis (ASCII byte representations)
and corresponding word/identifier meanings.}

\item{\ldots}{Other arguments passed to \code{.mgsub} (see
\code{textclean:::.mgsub} for details).}
}
\value{
Returns a vector of strings with emojis replaced with word
equivalents.
}
\description{
Replaces emojis with word equivalents or a token identifier for use in the
\pkg{sentimentr} package.  Not that this function will coerce the text to 
ASCII using \code{Encoding(x) <- "latin1"; iconv(x, "latin1", "ASCII", "byte")}.
The function \code{replace_emoji} replaces emojis with text representations
while \code{replace_emoji_identifier} replaces with a unique identifier that
corresponds to \code{lexicon::hash_sentiment_emoji} for use in the 
\pkg{sentimentr} package.
}
\examples{
x <- readLines(system.file("docs/emoji_sample.txt", package = "textclean"))[1]
replace_emoji(x)
replace_emoji_identifier(x)
}
\keyword{emoji}
