% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgsub.R
\name{mgsub}
\alias{mgsub}
\alias{mgsub_fixed}
\alias{mgsub_regex}
\title{Multiple \code{\link[base]{gsub}}}
\usage{
mgsub(x, pattern, replacement, leadspace = FALSE, trailspace = FALSE,
  fixed = TRUE, trim = FALSE, order.pattern = fixed, ...)

mgsub_fixed(x, pattern, replacement, leadspace = FALSE, trailspace = FALSE,
  fixed = TRUE, trim = FALSE, order.pattern = fixed, ...)

mgsub_regex(x, pattern, replacement, leadspace = FALSE, trailspace = FALSE,
  fixed = FALSE, trim = FALSE, order.pattern = fixed, ...)
}
\arguments{
\item{x}{A character vector.}

\item{pattern}{Character string to be matched in the given character vector.}

\item{replacement}{Character string equal in length to pattern or of length 
one which are  a replacement for matched pattern.}

\item{leadspace}{logical.  If \code{TRUE} inserts a leading space in the 
replacements.}

\item{trailspace}{logical.  If \code{TRUE} inserts a trailing space in the 
replacements.}

\item{fixed}{logical. If \code{TRUE}, pattern is a string to be matched as is. 
Overrides all conflicting arguments.}

\item{trim}{logical.  If \code{TRUE} leading and trailing white spaces are 
removed and multiple white spaces are reduced to a single white space.}

\item{order.pattern}{logical.  If \code{TRUE} and \code{fixed = TRUE}, the 
\code{pattern} string is sorted by number of characters to prevent substrings 
replacing meta strings (e.g., \code{pattern = c("the", "then")} resorts to 
search for "then" first).}

\item{\dots}{Additional arguments passed to \code{\link[base]{gsub}}.}
}
\value{
\code{mgsub} - Returns a vector with the pattern replaced.
}
\description{
\code{mgsub} - A wrapper for \code{\link[base]{gsub}} that takes a vector 
of search terms and a vector or single value of replacements.

\code{mgsub_fixed} - An alias for \code{mgsub}.

\code{mgsub_regex} - An wrapper for \code{mgsub} with \code{fixed = FALSE}.
}
\examples{
mgsub(DATA$state, c("it's", "I'm"), c("it is", "I am"))
mgsub(DATA$state, "[[:punct:]]", "PUNC", fixed = FALSE)
}
\seealso{
\code{\link[textclean]{replace_tokens}}
\code{\link[base]{gsub}}
}
