% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_url.R
\name{replace_url}
\alias{replace_url}
\title{Replace URLs}
\usage{
replace_url(x, pattern = qdapRegex::grab("rm_url"), replacement = "", ...)
}
\arguments{
\item{x}{The text variable.}

\item{pattern}{Character time regex string to be matched in the given 
character vector.}

\item{replacement}{A function to operate on the extracted matches or a 
character string which is a replacement for the matched pattern.}

\item{\ldots}{ignored.}
}
\value{
Returns a vector with URLs replaced.
}
\description{
Replaces URLs.
}
\examples{
x <- c("@hadley I like #rstats for #ggplot2 work. ftp://cran.r-project.org/incoming/",
    "Difference between #magrittr and #pipeR, both implement pipeline operators for #rstats: 
        http://renkun.me/r/2014/07/26/difference-between-magrittr-and-pipeR.html @timelyportfolio",
    "Slides from great talk: @ramnath_vaidya: Interactive slides from Interactive Visualization 
        presentation #user2014. https://ramnathv.github.io/user2014-rcharts/#1",
    NA 
)

replace_url(x)
replace_url(x, replacement = '<<URL>>')

\dontrun{
## Replacement with a function
library(urltools)
replace_url(x, 
    replacement = function(x){
        sprintf('{{\%s}}', urltools::url_parse(x)$domain)
    }
)
}
}
