% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refit.R
\name{refit}
\alias{refit}
\title{Refit the Documents Under an Alternate Treatment Level}
\usage{
refit(stm_model, documents, content_level, verbose = TRUE)
}
\arguments{
\item{stm_model}{the stm content covariate model from which to develop the projection}

\item{documents}{the documents that we want to refit.  This currently only
works if these are the original documents used to fit the model.  However, this same
refitting procedure could be done by using \link[stm]{fitNewDocuments} in the \pkg{stm}.}

\item{content_level}{a string containing the level under which to refit the documents}

\item{verbose}{a logical indicating if progress should be printed to the screen}
}
\value{
list
\item{content_level}{the level of the content covariate}
\item{theta}{the document-topic matrix refit under the new content level}
}
\description{
A function to refit all the document loadings in an STM under an alternative content covariate level.
}
\details{
This function cycles through all the documents and refits the theta parameter (the document-topic loadings)
as though they all had the same level of the content covariate as specified by \code{content_level}.
For documents that already had that content_level the results should be very close to their originally
learned value of theta if the model had converged.  However, because \pkg{stm} is an iterative algorithm
and the global parameters are updated last, they could be different.
}
\examples{
\donttest{
 data(sim)
 refitted <- refit(sim_topics, sim_documents, content_level="1")
}
}
\references{
Roberts, M., Stewart, B., Nielsen, R. (2020)
"Adjusting for Confounding with Text Matching." 
In American Journal of Political Science
}
