% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_set_functions.R
\name{setMeta}
\alias{setMeta}
\title{Function to access meta data for textmining objects}
\usage{
setMeta(x, parameter, value, i = 1)
}
\arguments{
\item{x}{object to retrive document fe tmCorpus or tmTextDocument}

\item{parameter}{name of metadata to be extracted}

\item{value}{value of meta data to set}

\item{i}{index}
}
\value{
returns i-th document of corpus x
}
\description{
Function to access meta data for textmining objects
}
\examples{
corp <- tmCorpus(c("This is first document", "This is second"))
corp <- setMeta(corp, parameter = "language", "pl", 1)
getMeta(corp, parameter = "language", 1)
meta(corp, "title") <- c("T1","T2")
meta(corp, "title")

text <- tmTextDocument("Text document")
text <- setMeta(text, "language", "de")
getMeta(text, "language")
meta(text, "title") <- "New"
meta(text, "title")

parsed <- tmParsed(list(c("Parsed", "doc", "one"), c("Parsed", "two")))
parsed <- setMeta(parsed, parameter = "title",  "New1", 2)
getMeta(parsed, parameter = "title",  2)
meta(parsed, "title") <- c("T1", "T2")
meta(parsed, "title")

}

