% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/antiword_loc.R, R/check_antiword_installed.R
\name{antiword_loc}
\alias{antiword_loc}
\alias{antiword_url}
\alias{check_antiword_installed}
\title{Make User Specific Path/URL to Antiword}
\usage{
antiword_loc()

antiword_url()

check_antiword_installed(antiword.path = textreadr::antiword_loc(),
  download = textreadr::antiword_url(), verbose = TRUE)
}
\arguments{
\item{antiword.path}{The path to the latest version of Antiword.}

\item{download}{The download url for Antiword.}

\item{verbose}{If \code{TRUE} messages are printed even when everything is
installed.}
}
\value{
returns a path as a string.
}
\description{
Make a user specific path/URL to Antiword.

Checks that Antiword is installed and in root.  Currently this function will
try to install Antiword if missing from root for Windows users only.  Other
users must install manually.
}
\examples{
antiword_loc()
\dontrun{
check_antiword_installed()
}
}
\references{
http://nlp.antiword.edu/software/antiword.shtml
}
\keyword{antiword}

