% Generated by roxygen2 (4.0.2): do not edit by hand
\name{predict.textreg.result}
\alias{predict.textreg.result}
\title{Predict labeling with the selected phrases.}
\usage{
\method{predict}{textreg.result}(object, new.text = NULL,
  return.matrix = FALSE, ...)
}
\arguments{
\item{object}{A textreg.result object}

\item{new.text}{If you want to predict for new text, pass it along.}

\item{return.matrix}{TRUE means hand back the phrase appearance pattern matrix.}

\item{...}{Nothing can be passed extra.}
}
\value{
Vector of predictions (numbers).
}
\description{
Given raw text and a textreg model, predict the labeling by counting appearance of
relevant phrases in text and then multiplying these counts by the beta vector
associated with the textreg object.  Just like linear regression.
}
\examples{
res = textreg( c( "", "", "A", "A" ), c( -1, -1, 1, 1 ),
      C=1, Lq=1, convergence.threshold=0.00000001, verbosity=0 )
predict( res )
predict( res, new.text=c("A B C A") )
}

